/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.AnyOfParser;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CompositeIdentityStringTokenizer;
import org.jetbrains.kotlin.commonizer.GeneratedToken;
import org.jetbrains.kotlin.commonizer.IdentityStringSyntaxNode;
import org.jetbrains.kotlin.commonizer.IdentityStringToken;
import org.jetbrains.kotlin.commonizer.IdentityStringTokenizer;
import org.jetbrains.kotlin.commonizer.IgnoreTokensParser;
import org.jetbrains.kotlin.commonizer.LeafCommonizerTarget;
import org.jetbrains.kotlin.commonizer.LeafTargetParser;
import org.jetbrains.kotlin.commonizer.ParseCommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.Parser;
import org.jetbrains.kotlin.commonizer.ParserOutput;
import org.jetbrains.kotlin.commonizer.RegexIdentityStringTokenizer;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.commonizer.SharedTargetParser;
import org.jetbrains.kotlin.commonizer.ZeroOrMoreParser;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a=\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\t0\u0001\"\b\b\u0000\u0010\t*\u00020\n2\u001e\u0010\u0000\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\t0\u00010\u000b\"\b\u0012\u0004\u0012\u0002H\t0\u0001H\u0002\u00a2\u0006\u0002\u0010\f\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a*\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\t0\u0001\"\b\b\u0000\u0010\t*\u00020\n*\b\u0012\u0004\u0012\u0002H\t0\u00012\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\u001a\u0015\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0082\u0002\u001a(\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\u00150\u0001\"\b\b\u0000\u0010\t*\u00020\n*\b\u0012\u0004\u0012\u0002H\t0\u0001H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"parser", "Lorg/jetbrains/kotlin/commonizer/Parser;", "Lorg/jetbrains/kotlin/commonizer/IdentityStringSyntaxNode;", "separatorTokenizer", "Lorg/jetbrains/kotlin/commonizer/RegexIdentityStringTokenizer;", "sharedTargetEndTokenizer", "sharedTargetStartTokenizer", "wordTokenizer", "anyOf", "T", "", "", "([Lorg/jetbrains/kotlin/commonizer/Parser;)Lorg/jetbrains/kotlin/commonizer/Parser;", "buildCommonizerTarget", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "node", "parseCommonizerTarget", "identityString", "", "parseCommonizerTargetOrNull", "tokenizeIdentityString", "", "Lorg/jetbrains/kotlin/commonizer/IdentityStringToken;", "ignore", "token", "plus", "Lorg/jetbrains/kotlin/commonizer/IdentityStringTokenizer;", "other", "zeroOrMore", "kotlin-klib-commonizer-api"})
public final class ParseCommonizerTargetKt {
    @NotNull
    private static final RegexIdentityStringTokenizer sharedTargetStartTokenizer = new RegexIdentityStringTokenizer(Regex.Companion.fromLiteral("("), (Function1<? super String, ? extends IdentityStringToken>)((Function1)sharedTargetStartTokenizer.1.INSTANCE));
    @NotNull
    private static final RegexIdentityStringTokenizer sharedTargetEndTokenizer = new RegexIdentityStringTokenizer(Regex.Companion.fromLiteral(")"), (Function1<? super String, ? extends IdentityStringToken>)((Function1)sharedTargetEndTokenizer.1.INSTANCE));
    @NotNull
    private static final RegexIdentityStringTokenizer separatorTokenizer = new RegexIdentityStringTokenizer(new Regex("\\s*,\\s*"), (Function1<? super String, ? extends IdentityStringToken>)((Function1)separatorTokenizer.1.INSTANCE));
    @NotNull
    private static final RegexIdentityStringTokenizer wordTokenizer = new RegexIdentityStringTokenizer(new Regex("\\w+"), (Function1<? super String, ? extends IdentityStringToken>)((Function1)wordTokenizer.1.INSTANCE));
    @NotNull
    private static final Parser<IdentityStringSyntaxNode> parser;

    @Nullable
    public static final CommonizerTarget parseCommonizerTargetOrNull(@NotNull String identityString) {
        CommonizerTarget commonizerTarget;
        Intrinsics.checkNotNullParameter((Object)identityString, (String)"identityString");
        try {
            commonizerTarget = ParseCommonizerTargetKt.parseCommonizerTarget(identityString);
        }
        catch (IllegalArgumentException t) {
            commonizerTarget = null;
        }
        return commonizerTarget;
    }

    @NotNull
    public static final CommonizerTarget parseCommonizerTarget(@NotNull String identityString) {
        Intrinsics.checkNotNullParameter((Object)identityString, (String)"identityString");
        try {
            List<IdentityStringToken> tokens = ParseCommonizerTargetKt.tokenizeIdentityString(identityString);
            ParserOutput<IdentityStringSyntaxNode> parserOutput = parser.invoke(tokens);
            if (parserOutput == null) {
                String string2 = Intrinsics.stringPlus((String)"Failed building syntax tree. ", (Object)identityString);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            ParserOutput<IdentityStringSyntaxNode> syntaxTree = parserOutput;
            boolean bl = syntaxTree.getRemaining().isEmpty();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string3 = Intrinsics.stringPlus((String)"Failed building syntax tree. Unexpected remaining tokens ", syntaxTree.getRemaining());
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            return ParseCommonizerTargetKt.buildCommonizerTarget(syntaxTree.getValue());
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed parsing CommonizerTarget from \"" + identityString + '\"', e);
        }
    }

    private static final List<IdentityStringToken> tokenizeIdentityString(String identityString) {
        String remainingString = null;
        remainingString = identityString;
        IdentityStringTokenizer tokenizer = ParseCommonizerTargetKt.plus(ParseCommonizerTargetKt.plus(ParseCommonizerTargetKt.plus(sharedTargetStartTokenizer, sharedTargetEndTokenizer), separatorTokenizer), wordTokenizer);
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$tokenizeIdentityString_u24lambda_u2d1 = list;
        boolean bl4 = false;
        while (true) {
            CharSequence charSequence = remainingString;
            boolean bl5 = false;
            if (!(charSequence.length() > 0)) break;
            GeneratedToken generatedToken = tokenizer.nextToken(remainingString);
            if (generatedToken == null) {
                String string2 = Intrinsics.stringPlus((String)"Unexpected token at ", (Object)remainingString);
                boolean bl6 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            GeneratedToken generatedToken2 = generatedToken;
            remainingString = generatedToken2.getRemaining();
            $this$tokenizeIdentityString_u24lambda_u2d1.add(generatedToken2.getToken());
        }
        return CollectionsKt.toList((Iterable)list);
    }

    private static final IdentityStringTokenizer plus(IdentityStringTokenizer $this$plus, IdentityStringTokenizer other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        return new CompositeIdentityStringTokenizer($this$plus, other);
    }

    private static final <T> Parser<T> anyOf(Parser<? extends T> ... parser) {
        return new AnyOfParser(ArraysKt.toList((Object[])parser));
    }

    private static final <T> Parser<List<T>> zeroOrMore(Parser<? extends T> $this$zeroOrMore) {
        return new ZeroOrMoreParser<T>($this$zeroOrMore);
    }

    private static final <T> Parser<T> ignore(Parser<? extends T> $this$ignore, IdentityStringToken token) {
        return new IgnoreTokensParser<T>($this$ignore, token);
    }

    /*
     * WARNING - void declaration
     */
    private static final CommonizerTarget buildCommonizerTarget(IdentityStringSyntaxNode node) {
        CommonizerTarget commonizerTarget;
        IdentityStringSyntaxNode identityStringSyntaxNode = node;
        if (identityStringSyntaxNode instanceof IdentityStringSyntaxNode.LeafTargetSyntaxNode) {
            commonizerTarget = new LeafCommonizerTarget(((IdentityStringSyntaxNode.LeafTargetSyntaxNode)node).getToken().getValue());
        } else if (identityStringSyntaxNode instanceof IdentityStringSyntaxNode.SharedTargetSyntaxNode) {
            Collection<CommonizerTarget> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((IdentityStringSyntaxNode.SharedTargetSyntaxNode)node).getChildren();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void child;
                IdentityStringSyntaxNode identityStringSyntaxNode2 = (IdentityStringSyntaxNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                CommonizerTarget commonizerTarget2 = ParseCommonizerTargetKt.buildCommonizerTarget((IdentityStringSyntaxNode)child);
                collection.add(commonizerTarget2);
            }
            collection = (List)destination$iv$iv;
            Set set = CollectionsKt.toSet((Iterable)collection);
            commonizerTarget = new SharedCommonizerTarget(set);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return commonizerTarget;
    }

    public static final /* synthetic */ Parser access$zeroOrMore(Parser $receiver) {
        return ParseCommonizerTargetKt.zeroOrMore($receiver);
    }

    public static final /* synthetic */ Parser access$ignore(Parser $receiver, IdentityStringToken token) {
        return ParseCommonizerTargetKt.ignore($receiver, token);
    }

    public static final /* synthetic */ Parser access$anyOf(Parser ... parser) {
        return ParseCommonizerTargetKt.anyOf(parser);
    }

    static {
        Parser[] parserArray = new Parser[]{SharedTargetParser.INSTANCE, LeafTargetParser.INSTANCE};
        parser = ParseCommonizerTargetKt.anyOf(parserArray);
    }
}

