/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.konan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.CommonizerParameters;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.FacadeKt;
import org.jetbrains.kotlin.commonizer.LeafCommonizerTarget;
import org.jetbrains.kotlin.commonizer.ModulesProvider;
import org.jetbrains.kotlin.commonizer.ResultsConsumer;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.commonizer.TargetDependent;
import org.jetbrains.kotlin.commonizer.TargetDependentKt;
import org.jetbrains.kotlin.commonizer.TargetProvider;
import org.jetbrains.kotlin.commonizer.konan.DefaultModulesProvider;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrariesToCommonize;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrary;
import org.jetbrains.kotlin.commonizer.konan.NativeLibraryKt;
import org.jetbrains.kotlin.commonizer.konan.NativeManifestDataProvider;
import org.jetbrains.kotlin.commonizer.repository.Repository;
import org.jetbrains.kotlin.commonizer.stats.StatsCollector;
import org.jetbrains.kotlin.commonizer.utils.ProgressLogger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0002J\u0010\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0012H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0002J\u0006\u0010\u001d\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/commonizer/konan/LibraryCommonizer;", "", "outputTarget", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "repository", "Lorg/jetbrains/kotlin/commonizer/repository/Repository;", "dependencies", "resultsConsumer", "Lorg/jetbrains/kotlin/commonizer/ResultsConsumer;", "statsCollector", "Lorg/jetbrains/kotlin/commonizer/stats/StatsCollector;", "progressLogger", "Lorg/jetbrains/kotlin/commonizer/utils/ProgressLogger;", "(Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;Lorg/jetbrains/kotlin/commonizer/repository/Repository;Lorg/jetbrains/kotlin/commonizer/repository/Repository;Lorg/jetbrains/kotlin/commonizer/ResultsConsumer;Lorg/jetbrains/kotlin/commonizer/stats/StatsCollector;Lorg/jetbrains/kotlin/commonizer/utils/ProgressLogger;)V", "checkPreconditions", "", "commonizeAndSaveResults", "libraries", "Lorg/jetbrains/kotlin/commonizer/TargetDependent;", "Lorg/jetbrains/kotlin/commonizer/konan/NativeLibrariesToCommonize;", "createDependenciesProvider", "Lorg/jetbrains/kotlin/commonizer/ModulesProvider;", "createManifestProvider", "Lorg/jetbrains/kotlin/commonizer/konan/NativeManifestDataProvider;", "createTargetProvider", "Lorg/jetbrains/kotlin/commonizer/TargetProvider;", "target", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "loadLibraries", "run", "kotlin-klib-commonizer"})
public final class LibraryCommonizer {
    @NotNull
    private final SharedCommonizerTarget outputTarget;
    @NotNull
    private final Repository repository;
    @NotNull
    private final Repository dependencies;
    @NotNull
    private final ResultsConsumer resultsConsumer;
    @Nullable
    private final StatsCollector statsCollector;
    @NotNull
    private final ProgressLogger progressLogger;

    public LibraryCommonizer(@NotNull SharedCommonizerTarget outputTarget, @NotNull Repository repository, @NotNull Repository dependencies, @NotNull ResultsConsumer resultsConsumer2, @Nullable StatsCollector statsCollector, @NotNull ProgressLogger progressLogger) {
        Intrinsics.checkNotNullParameter((Object)outputTarget, (String)"outputTarget");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)resultsConsumer2, (String)"resultsConsumer");
        Intrinsics.checkNotNullParameter((Object)progressLogger, (String)"progressLogger");
        this.outputTarget = outputTarget;
        this.repository = repository;
        this.dependencies = dependencies;
        this.resultsConsumer = resultsConsumer2;
        this.statsCollector = statsCollector;
        this.progressLogger = progressLogger;
    }

    public final void run() {
        this.checkPreconditions();
        TargetDependent<NativeLibrariesToCommonize> allLibraries = this.loadLibraries();
        this.commonizeAndSaveResults(allLibraries);
        this.progressLogger.logTotal();
    }

    /*
     * WARNING - void declaration
     */
    private final TargetDependent<NativeLibrariesToCommonize> loadLibraries() {
        TargetDependent<NativeLibrariesToCommonize> libraries2;
        TargetDependent<NativeLibrariesToCommonize> $this$forEachWithTarget$iv = libraries2 = TargetDependentKt.EagerTargetDependent((Iterable<? extends CommonizerTarget>)CommonizerTargetKt.allLeaves(this.outputTarget), (Function1)new Function1<CommonizerTarget, NativeLibrariesToCommonize>(this){
            final /* synthetic */ LibraryCommonizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final NativeLibrariesToCommonize invoke(@NotNull CommonizerTarget target) {
                NativeLibrariesToCommonize nativeLibrariesToCommonize;
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Collection $this$ifNotEmpty$iv = CollectionsKt.toList((Iterable)LibraryCommonizer.access$getRepository$p(this.this$0).getLibraries(target));
                boolean $i$f$ifNotEmpty = false;
                Collection collection = $this$ifNotEmpty$iv;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    List $this$invoke_u24lambda_u2d0 = (List)$this$ifNotEmpty$iv;
                    boolean bl2 = false;
                    nativeLibrariesToCommonize = new NativeLibrariesToCommonize(target, $this$invoke_u24lambda_u2d0);
                } else {
                    nativeLibrariesToCommonize = null;
                }
                return nativeLibrariesToCommonize;
            }
        });
        boolean $i$f$forEachWithTarget = false;
        Iterable $this$forEach$iv$iv = $this$forEachWithTarget$iv.getTargets();
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            void librariesOrNull;
            CommonizerTarget target$iv = (CommonizerTarget)element$iv$iv;
            boolean bl = false;
            NativeLibrariesToCommonize nativeLibrariesToCommonize = $this$forEachWithTarget$iv.get(target$iv);
            CommonizerTarget target = target$iv;
            boolean bl2 = false;
            if (librariesOrNull != null) continue;
            this.progressLogger.warning("No libraries found for target " + CommonizerTargetKt.getPrettyName(target) + ". This target will be excluded from commonization.");
        }
        this.progressLogger.progress("Resolved libraries to be commonized");
        return libraries2;
    }

    private final void commonizeAndSaveResults(TargetDependent<NativeLibrariesToCommonize> libraries2) {
        SharedCommonizerTarget sharedCommonizerTarget = this.outputTarget;
        TargetDependent<TargetProvider> targetDependent = libraries2.map((Function2)new Function2<CommonizerTarget, NativeLibrariesToCommonize, TargetProvider>(this){
            final /* synthetic */ LibraryCommonizer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final TargetProvider invoke(@NotNull CommonizerTarget target, @Nullable NativeLibrariesToCommonize targetLibraries) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return LibraryCommonizer.access$createTargetProvider(this.this$0, target, targetLibraries);
            }
        });
        TargetDependent<NativeManifestDataProvider> targetDependent2 = this.createManifestProvider(libraries2);
        TargetDependent<ModulesProvider> targetDependent3 = this.createDependenciesProvider();
        ResultsConsumer resultsConsumer2 = this.resultsConsumer;
        StatsCollector statsCollector = this.statsCollector;
        ProgressLogger progressLogger = this.progressLogger;
        CommonizerParameters parameters2 = new CommonizerParameters(sharedCommonizerTarget, targetDependent2, targetDependent3, targetDependent, resultsConsumer2, statsCollector, progressLogger);
        FacadeKt.runCommonization(parameters2);
    }

    private final TargetProvider createTargetProvider(CommonizerTarget target, NativeLibrariesToCommonize libraries2) {
        if (libraries2 == null) {
            return null;
        }
        return new TargetProvider(target, DefaultModulesProvider.Companion.create(libraries2));
    }

    private final TargetDependent<ModulesProvider> createDependenciesProvider() {
        return TargetDependentKt.TargetDependent((Iterable<? extends CommonizerTarget>)CommonizerTargetKt.withAllAncestors(this.outputTarget), (Function1)new Function1<CommonizerTarget, ModulesProvider>(this){
            final /* synthetic */ LibraryCommonizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ModulesProvider invoke(@NotNull CommonizerTarget target) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return DefaultModulesProvider.Companion.create((Iterable<NativeLibrary>)LibraryCommonizer.access$getDependencies$p(this.this$0).getLibraries(target));
            }
        });
    }

    private final TargetDependent<NativeManifestDataProvider> createManifestProvider(TargetDependent<NativeLibrariesToCommonize> libraries2) {
        return TargetDependentKt.TargetDependent((Iterable<? extends CommonizerTarget>)CommonizerTargetKt.withAllAncestors(this.outputTarget), (Function1)new Function1<CommonizerTarget, NativeManifestDataProvider>(libraries2){
            final /* synthetic */ TargetDependent<NativeLibrariesToCommonize> $libraries;
            {
                this.$libraries = $libraries;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final NativeManifestDataProvider invoke(@NotNull CommonizerTarget target) {
                NativeManifestDataProvider nativeManifestDataProvider;
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                CommonizerTarget commonizerTarget = target;
                if (commonizerTarget instanceof LeafCommonizerTarget) {
                    NativeLibrariesToCommonize nativeLibrariesToCommonize = this.$libraries.get(target);
                    if (nativeLibrariesToCommonize == null) {
                        String string2 = Intrinsics.stringPlus((String)"Can't provide manifest for missing target ", (Object)target);
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    nativeManifestDataProvider = nativeLibrariesToCommonize;
                } else if (commonizerTarget instanceof SharedCommonizerTarget) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Iterable iterable = CommonizerTargetKt.allLeaves(target);
                    TargetDependent<NativeLibrariesToCommonize> targetDependent = this.$libraries;
                    CommonizerTarget commonizerTarget2 = target;
                    boolean $i$f$mapNotNull = false;
                    void var6_10 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        NativeLibrariesToCommonize nativeLibrariesToCommonize;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        LeafCommonizerTarget leafTarget = (LeafCommonizerTarget)element$iv$iv;
                        boolean bl2 = false;
                        if (targetDependent.getOrNull(leafTarget) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        NativeLibrariesToCommonize it$iv$iv = nativeLibrariesToCommonize;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List list = (List)destination$iv$iv;
                    nativeManifestDataProvider = NativeLibraryKt.NativeManifestDataProvider(commonizerTarget2, list);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return nativeManifestDataProvider;
            }
        });
    }

    private final void checkPreconditions() {
        int n = CommonizerTargetKt.allLeaves(this.outputTarget).size();
        switch (n) {
            case 0: {
                this.progressLogger.fatal("No targets specified");
                throw null;
            }
            case 1: {
                this.progressLogger.fatal(Intrinsics.stringPlus((String)"Too few targets specified: ", (Object)this.outputTarget));
                throw null;
            }
        }
    }

    public static final /* synthetic */ Repository access$getRepository$p(LibraryCommonizer $this) {
        return $this.repository;
    }

    public static final /* synthetic */ TargetProvider access$createTargetProvider(LibraryCommonizer $this, CommonizerTarget target, NativeLibrariesToCommonize libraries2) {
        return $this.createTargetProvider(target, libraries2);
    }

    public static final /* synthetic */ Repository access$getDependencies$p(LibraryCommonizer $this) {
        return $this.dependencies;
    }
}

