/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.library.encodings;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u001d\u0010\u0013\u001a\u00020\u0014*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0082\u0002J\u001d\u0010\u0013\u001a\u00020\u0014*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0082\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkotlinx/metadata/internal/library/encodings/WobblyTF8;", "", "()V", "EMPTY_BYTE_ARRAY", "", "EMPTY_STRING", "", "REPLACEMENT_CHAR", "", "decode", "array", "encode", "string", "isValidContinuation", "", "byteN", "", "readByteAsInt", "index", "set", "", "value", "", "kotlin-util-klib"})
public final class WobblyTF8 {
    @NotNull
    public static final WobblyTF8 INSTANCE = new WobblyTF8();
    @NotNull
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @NotNull
    private static final String EMPTY_STRING = "";
    private static final char REPLACEMENT_CHAR = '\ufffd';

    private WobblyTF8() {
    }

    @NotNull
    public final byte[] encode(@NotNull String string2) {
        byte[] byArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        int stringLength = string2.length();
        if (stringLength == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] buffer = new byte[stringLength * 3];
        int writtenBytes = 0;
        int index = 0;
        while (index < stringLength) {
            char char2;
            int codePoint;
            int n2;
            int n3;
            n = index;
            index = n + 1;
            int char1 = string2.charAt(n);
            if (Intrinsics.compare((int)char1, (int)128) < 0) {
                n = writtenBytes;
                writtenBytes = n + 1;
                int n4 = n;
                n = char1;
                n3 = 0;
                this.set(buffer, n4, n);
                continue;
            }
            if (Intrinsics.compare((int)char1, (int)2048) < 0) {
                n3 = char1;
                n2 = 0;
                codePoint = n3;
                n3 = writtenBytes;
                writtenBytes = n3 + 1;
                this.set(buffer, n3, codePoint >>> 6 | 0xC0);
                n3 = writtenBytes;
                writtenBytes = n3 + 1;
                this.set(buffer, n3, codePoint & 0x3F | 0x80);
                continue;
            }
            if (Character.isHighSurrogate((char)char1) && index < stringLength && Character.isLowSurrogate(char2 = string2.charAt(index))) {
                n3 = index;
                index = n3 + 1;
                int codePoint2 = Character.toCodePoint((char)char1, char2);
                n2 = writtenBytes;
                writtenBytes = n2 + 1;
                this.set(buffer, n2, codePoint2 >>> 18 | 0xF0);
                n2 = writtenBytes;
                writtenBytes = n2 + 1;
                this.set(buffer, n2, codePoint2 >>> 12 & 0x3F | 0x80);
                n2 = writtenBytes;
                writtenBytes = n2 + 1;
                this.set(buffer, n2, codePoint2 >>> 6 & 0x3F | 0x80);
                n2 = writtenBytes;
                writtenBytes = n2 + 1;
                this.set(buffer, n2, codePoint2 & 0x3F | 0x80);
                continue;
            }
            n3 = char1;
            n2 = 0;
            codePoint = n3;
            n3 = writtenBytes;
            writtenBytes = n3 + 1;
            this.set(buffer, n3, codePoint >>> 12 | 0xE0);
            n3 = writtenBytes;
            writtenBytes = n3 + 1;
            this.set(buffer, n3, codePoint >>> 6 & 0x3F | 0x80);
            n3 = writtenBytes;
            writtenBytes = n3 + 1;
            this.set(buffer, n3, codePoint & 0x3F | 0x80);
        }
        if (buffer.length == writtenBytes) {
            byArray = buffer;
        } else {
            byte[] byArray2 = buffer;
            n = 0;
            byte[] byArray3 = Arrays.copyOf(byArray2, writtenBytes);
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
        }
        return byArray;
    }

    @NotNull
    public final String decode(@NotNull byte[] array) {
        String string2;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int arraySize = array.length;
        if (arraySize == 0) {
            return EMPTY_STRING;
        }
        char[] buffer = new char[arraySize];
        int charsWritten = 0;
        int index = 0;
        while (index < arraySize) {
            int byte4;
            int n3;
            int byte3;
            int n4;
            int byte2;
            n2 = index;
            index = n2 + 1;
            int byte1 = this.readByteAsInt(array, n2);
            if ((byte1 & 0x80) == 0) {
                n2 = charsWritten;
                charsWritten = n2 + 1;
                this.set(buffer, n2, byte1);
                continue;
            }
            if (byte1 >>> 5 == 6) {
                if (index < arraySize && this.isValidContinuation(byte2 = this.readByteAsInt(array, index))) {
                    n4 = index;
                    index = n4 + 1;
                    n4 = charsWritten;
                    charsWritten = n4 + 1;
                    this.set(buffer, n4, (byte1 & 0x1F) << 6 | byte2 & 0x3F);
                    continue;
                }
            } else if (byte1 >>> 4 == 14) {
                if (index < arraySize && this.isValidContinuation(byte2 = this.readByteAsInt(array, index)) && (index = (n4 = index) + 1) < arraySize && this.isValidContinuation(byte3 = this.readByteAsInt(array, index))) {
                    n3 = index;
                    index = n3 + 1;
                    n3 = charsWritten;
                    charsWritten = n3 + 1;
                    this.set(buffer, n3, (byte1 & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F);
                    continue;
                }
            } else if (byte1 >>> 3 == 30 && index < arraySize && this.isValidContinuation(byte2 = this.readByteAsInt(array, index)) && (index = (byte3 = index) + 1) < arraySize && this.isValidContinuation(byte3 = this.readByteAsInt(array, index)) && (index = (n3 = index) + 1) < arraySize && this.isValidContinuation(byte4 = this.readByteAsInt(array, index))) {
                int n5 = index;
                index = n5 + 1;
                int codePoint = (byte1 & 7) << 18 | (byte2 & 0x3F) << 12 | (byte3 & 0x3F) << 6 | byte4 & 0x3F;
                int n6 = charsWritten;
                charsWritten = n6 + 1;
                buffer[n6] = Character.highSurrogate(codePoint);
                n6 = charsWritten;
                charsWritten = n6 + 1;
                buffer[n6] = Character.lowSurrogate(codePoint);
                continue;
            }
            n2 = charsWritten;
            charsWritten = n2 + 1;
            buffer[n2] = 65533;
        }
        if (buffer.length == charsWritten) {
            n = 0;
            string2 = new String(buffer);
        } else {
            n = 0;
            n2 = 0;
            string2 = new String(buffer, n, charsWritten);
        }
        return string2;
    }

    private final int readByteAsInt(byte[] $this$readByteAsInt, int index) {
        return $this$readByteAsInt[index] & 0xFF;
    }

    private final void set(byte[] $this$set, int index, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        $this$set[index] = (byte)value;
    }

    private final void set(char[] $this$set, int index, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        $this$set[index] = (char)value;
    }

    private final boolean isValidContinuation(int byteN) {
        return byteN >>> 6 == 2;
    }
}

