/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.cir;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirName;
import org.jetbrains.kotlin.commonizer.cir.CirPackageName;
import org.jetbrains.kotlin.commonizer.utils.Interner;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006J\u0013\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "", "packageName", "Lorg/jetbrains/kotlin/commonizer/cir/CirPackageName;", "relativeNameSegments", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "(Lorg/jetbrains/kotlin/commonizer/cir/CirPackageName;[Lorg/jetbrains/kotlin/commonizer/cir/CirName;)V", "isNestedEntity", "", "()Z", "getPackageName", "()Lorg/jetbrains/kotlin/commonizer/cir/CirPackageName;", "getRelativeNameSegments", "()[Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "[Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "createNestedEntityId", "entityName", "equals", "other", "getParentEntityId", "hashCode", "", "toString", "", "Companion", "kotlin-klib-commonizer"})
public final class CirEntityId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CirPackageName packageName;
    @NotNull
    private final CirName[] relativeNameSegments;
    @NotNull
    private static final Interner<CirEntityId> interner = new Interner();

    private CirEntityId(CirPackageName packageName, CirName[] relativeNameSegments) {
        this.packageName = packageName;
        this.relativeNameSegments = relativeNameSegments;
    }

    @NotNull
    public final CirPackageName getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final CirName[] getRelativeNameSegments() {
        return this.relativeNameSegments;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CirEntityId)) return false;
        if (!Intrinsics.areEqual((Object)((CirEntityId)other).packageName, (Object)this.packageName)) return false;
        Object[] objectArray = ((CirEntityId)other).relativeNameSegments;
        Object[] objectArray2 = this.relativeNameSegments;
        boolean bl = false;
        if (!Arrays.equals(objectArray, objectArray2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void $this$appendHashCode$iv;
        int n;
        CirPackageName value$iv22 = this.packageName;
        boolean $i$f$hashCode = false;
        CirPackageName cirPackageName = value$iv22;
        boolean bl = false;
        CirPackageName cirPackageName2 = cirPackageName;
        int value$iv22 = cirPackageName2 != null ? ((Object)cirPackageName2).hashCode() : 0;
        Object[] array$iv = this.relativeNameSegments;
        boolean $i$f$appendHashCode = false;
        boolean $i$f$hashCode2 = false;
        Object[] objectArray = array$iv;
        if (objectArray == null) {
            n = 0;
        } else {
            int n2;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            n = n2 = Arrays.hashCode(objectArray2);
        }
        return 31 * $this$appendHashCode$iv + n;
    }

    @NotNull
    public String toString() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        ArraysKt.joinTo$default((Object[])this.getPackageName().getSegments(), (Appendable)$this$toString_u24lambda_u2d0, (CharSequence)"/", null, null, (int)0, null, null, (int)124, null);
        $this$toString_u24lambda_u2d0.append('/');
        ArraysKt.joinTo$default((Object[])this.getRelativeNameSegments(), (Appendable)$this$toString_u24lambda_u2d0, (CharSequence)".", null, null, (int)0, null, null, (int)124, null);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public final boolean isNestedEntity() {
        return this.relativeNameSegments.length > 1;
    }

    @NotNull
    public final CirEntityId createNestedEntityId(@NotNull CirName entityName) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        return Companion.create(this.packageName, (CirName[])ArraysKt.plus((Object[])this.relativeNameSegments, (Object)entityName));
    }

    @Nullable
    public final CirEntityId getParentEntityId() {
        CirEntityId cirEntityId;
        if (this.isNestedEntity()) {
            Object[] objectArray = this.relativeNameSegments;
            int n = 0;
            int n2 = this.relativeNameSegments.length - 1;
            boolean bl = false;
            cirEntityId = Companion.create(this.packageName, (CirName[])ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2));
        } else {
            cirEntityId = null;
        }
        return cirEntityId;
    }

    public /* synthetic */ CirEntityId(CirPackageName packageName, CirName[] relativeNameSegments, DefaultConstructorMarker $constructor_marker) {
        this(packageName, relativeNameSegments);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ!\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId$Companion;", "", "()V", "interner", "Lorg/jetbrains/kotlin/commonizer/utils/Interner;", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "create", "entityId", "", "packageName", "Lorg/jetbrains/kotlin/commonizer/cir/CirPackageName;", "relativeNameSegments", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "(Lorg/jetbrains/kotlin/commonizer/cir/CirPackageName;[Lorg/jetbrains/kotlin/commonizer/cir/CirName;)Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "relativeName", "classifierId", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlin-klib-commonizer"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CirEntityId create(@NotNull String entityId) {
            Object[] objectArray;
            Object[] objectArray2;
            CirName[] cirNameArray;
            int n;
            Object[] objectArray3;
            String string2;
            Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
            String rawPackageName = null;
            String rawRelativeName = null;
            int index = StringsKt.lastIndexOf$default((CharSequence)entityId, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                rawPackageName = "";
                rawRelativeName = entityId;
            } else {
                string2 = entityId;
                int n2 = 0;
                boolean bl = false;
                String string3 = string2.substring(n2, index);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                rawPackageName = string3;
                string2 = entityId;
                n2 = index + 1;
                bl = false;
                String string4 = string2.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                rawRelativeName = string4;
            }
            string2 = "/";
            CirName[] cirNameArray2 = CirPackageName.Companion;
            boolean $i$f$splitComplexNameToArray22 = false;
            CharSequence charSequence = rawPackageName;
            int n3 = 0;
            if (charSequence.length() == 0) {
                boolean $i$f$emptyArray = false;
                objectArray3 = new String[0];
            } else {
                void delimiter$iv;
                String[] stringArray = new String[]{delimiter$iv};
                List segments$iv = StringsKt.split$default((CharSequence)rawPackageName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                n3 = 0;
                int n4 = segments$iv.size();
                String[] stringArray2 = new String[n4];
                while (n3 < n4) {
                    void it;
                    n = n3++;
                    cirNameArray = (CirName[])segments$iv.get(n);
                    int n5 = n;
                    objectArray2 = stringArray2;
                    boolean bl = false;
                    void var19_30 = it;
                    objectArray2[n5] = var19_30;
                }
                objectArray3 = stringArray2;
            }
            objectArray2 = objectArray3;
            CirPackageName packageName = cirNameArray2.create((String[])objectArray2);
            String $i$f$splitComplexNameToArray22 = ".";
            CirName.Companion companion = CirName.Companion;
            boolean $i$f$splitComplexNameToArray = false;
            CharSequence charSequence2 = rawRelativeName;
            boolean bl = false;
            if (charSequence2.length() == 0) {
                boolean $i$f$emptyArray = false;
                objectArray = new CirName[0];
            } else {
                void delimiter$iv;
                String[] stringArray = new String[]{delimiter$iv};
                List segments$iv = StringsKt.split$default((CharSequence)rawRelativeName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                int n6 = 0;
                n = segments$iv.size();
                cirNameArray = new CirName[n];
                while (n6 < n) {
                    void p0;
                    CirName cirName;
                    int n7 = n6++;
                    String string5 = (String)segments$iv.get(n7);
                    int n8 = n7;
                    cirNameArray2 = cirNameArray;
                    boolean bl2 = false;
                    cirNameArray2[n8] = cirName = companion.create((String)p0);
                }
                objectArray = cirNameArray;
            }
            CirName[] relativeNameSegments = (CirName[])objectArray;
            return this.create(packageName, relativeNameSegments);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CirEntityId create(@NotNull ClassId classifierId) {
            Object[] objectArray;
            void complexName$iv;
            Intrinsics.checkNotNullParameter((Object)classifierId, (String)"classifierId");
            FqName fqName = classifierId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"classifierId.packageFqName");
            CirPackageName packageName = CirPackageName.Companion.create(fqName);
            String string2 = classifierId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classifierId.relativeClassName.asString()");
            String string3 = ".";
            CirName.Companion companion = CirName.Companion;
            boolean $i$f$splitComplexNameToArray = false;
            CharSequence charSequence = (CharSequence)complexName$iv;
            boolean bl = false;
            if (charSequence.length() == 0) {
                boolean $i$f$emptyArray = false;
                objectArray = new CirName[0];
            } else {
                void delimiter$iv;
                String[] stringArray = new String[]{delimiter$iv};
                List segments$iv = StringsKt.split$default((CharSequence)((CharSequence)complexName$iv), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                int n = 0;
                int n2 = segments$iv.size();
                CirName[] cirNameArray = new CirName[n2];
                while (n < n2) {
                    void p0;
                    CirName cirName;
                    int n3 = n++;
                    String string4 = (String)segments$iv.get(n3);
                    int n4 = n3;
                    CirName[] cirNameArray2 = cirNameArray;
                    boolean bl2 = false;
                    cirNameArray2[n4] = cirName = companion.create((String)p0);
                }
                objectArray = cirNameArray;
            }
            CirName[] relativeNameSegments = (CirName[])objectArray;
            return this.create(packageName, relativeNameSegments);
        }

        @NotNull
        public final CirEntityId create(@NotNull CirPackageName packageName, @NotNull CirName relativeName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)relativeName, (String)"relativeName");
            CirName[] cirNameArray = new CirName[]{relativeName};
            return this.create(packageName, cirNameArray);
        }

        @NotNull
        public final CirEntityId create(@NotNull CirPackageName packageName, @NotNull CirName[] relativeNameSegments) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)relativeNameSegments, (String)"relativeNameSegments");
            return interner.intern(new CirEntityId(packageName, relativeNameSegments, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

