/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirClassOrTypeAliasType;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeAliasType;
import org.jetbrains.kotlin.commonizer.core.AssociativeCommonizer;
import org.jetbrains.kotlin.commonizer.core.ClassOrTypeAliasTypeCommonizerKt;
import org.jetbrains.kotlin.commonizer.core.ClassTypeCommonizer;
import org.jetbrains.kotlin.commonizer.core.CommonizerKt;
import org.jetbrains.kotlin.commonizer.core.OptimisticNumbersTypeCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeAliasTypeCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeCommonizer;
import org.jetbrains.kotlin.commonizer.mergedtree.CirKnownClassifiers;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/ClassOrTypeAliasTypeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AssociativeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassOrTypeAliasType;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;", "options", "Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer$Options;", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer$Options;)V", "commonize", "first", "second", "kotlin-klib-commonizer"})
public final class ClassOrTypeAliasTypeCommonizer
implements AssociativeCommonizer<CirClassOrTypeAliasType> {
    @NotNull
    private final CirKnownClassifiers classifiers;
    @NotNull
    private final TypeCommonizer.Options options;

    public ClassOrTypeAliasTypeCommonizer(@NotNull CirKnownClassifiers classifiers2, @NotNull TypeCommonizer.Options options) {
        Intrinsics.checkNotNullParameter((Object)classifiers2, (String)"classifiers");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.classifiers = classifiers2;
        this.options = options;
    }

    @Override
    @Nullable
    public CirClassOrTypeAliasType commonize(@NotNull CirClassOrTypeAliasType first, @NotNull CirClassOrTypeAliasType second) {
        CirTypeAliasType cirTypeAliasType;
        CirClassType cirClassType;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (first instanceof CirClassType && second instanceof CirClassType) {
            Object[] objectArray = new CirClassType[]{(CirClassType)first, (CirClassType)second};
            CirClassType cirClassType2 = (CirClassType)CommonizerKt.commonize(new ClassTypeCommonizer(this.classifiers, this.options), CollectionsKt.listOf((Object[])objectArray));
            return cirClassType2 == null ? (CirClassOrTypeAliasType)(this.options.getEnableOptimisticNumberTypeCommonization() ? OptimisticNumbersTypeCommonizer.INSTANCE.commonize((CirClassType)first, (CirClassType)second) : null) : (CirClassOrTypeAliasType)cirClassType2;
        }
        if (first instanceof CirTypeAliasType && second instanceof CirTypeAliasType) {
            Object[] objectArray = new CirTypeAliasType[]{(CirTypeAliasType)first, (CirTypeAliasType)second};
            CirClassOrTypeAliasType cirClassOrTypeAliasType = (CirClassOrTypeAliasType)CommonizerKt.commonize(new TypeAliasTypeCommonizer(this.classifiers, this.options), CollectionsKt.listOf((Object[])objectArray));
            return cirClassOrTypeAliasType == null ? new ClassOrTypeAliasTypeCommonizer(this.classifiers, TypeCommonizer.Options.withOptimisticNumberTypeCommonizationEnabled$default(this.options, false, 1, null)).commonize(ClassOrTypeAliasTypeCommonizerKt.expandedType(first), ClassOrTypeAliasTypeCommonizerKt.expandedType(second)) : cirClassOrTypeAliasType;
        }
        if (first instanceof CirClassType) {
            cirClassType = (CirClassType)first;
        } else if (second instanceof CirClassType) {
            cirClassType = (CirClassType)second;
        } else {
            return null;
        }
        CirClassType classType = cirClassType;
        if (first instanceof CirTypeAliasType) {
            cirTypeAliasType = (CirTypeAliasType)first;
        } else if (second instanceof CirTypeAliasType) {
            cirTypeAliasType = (CirTypeAliasType)second;
        } else {
            return null;
        }
        CirTypeAliasType typeAliasType = cirTypeAliasType;
        CirClassOrTypeAliasType cirClassOrTypeAliasType = (CirClassOrTypeAliasType)CommonizerKt.commonize(new TypeAliasTypeCommonizer(this.classifiers, this.options), CollectionsKt.listOf((Object)typeAliasType));
        CirClassType typeAliasClassType = cirClassOrTypeAliasType == null ? ClassOrTypeAliasTypeCommonizerKt.expandedType(typeAliasType) : ClassOrTypeAliasTypeCommonizerKt.expandedType(cirClassOrTypeAliasType);
        return this.commonize(classType, typeAliasClassType);
    }
}

