/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.name;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.metadata.internal.name.Name;
import kotlinx.metadata.internal.name.SpecialNames;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0003J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkotlinx/metadata/internal/name/NameUtils;", "", "()V", "SANITIZE_AS_JAVA_INVALID_CHARACTERS", "Lkotlin/text/Regex;", "capitalizeAsJavaClassName", "", "str", "getPackagePartClassNamePrefix", "shortFileName", "getScriptNameForFile", "Lkotlinx/metadata/internal/name/Name;", "filePath", "hasName", "", "name", "sanitizeAsJavaIdentifier", "compiler.common"})
public final class NameUtils {
    @NotNull
    public static final NameUtils INSTANCE = new NameUtils();
    @NotNull
    private static final Regex SANITIZE_AS_JAVA_INVALID_CHARACTERS = new Regex("[^\\p{L}\\p{Digit}]");

    private NameUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String sanitizeAsJavaIdentifier(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return SANITIZE_AS_JAVA_INVALID_CHARACTERS.replace((CharSequence)name, "_");
    }

    @JvmStatic
    @NotNull
    public static final String getPackagePartClassNamePrefix(@NotNull String shortFileName) {
        Intrinsics.checkNotNullParameter((Object)shortFileName, (String)"shortFileName");
        return ((CharSequence)shortFileName).length() == 0 ? "_" : NameUtils.capitalizeAsJavaClassName(NameUtils.sanitizeAsJavaIdentifier(shortFileName));
    }

    @JvmStatic
    private static final String capitalizeAsJavaClassName(String str) {
        String string2;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = String.valueOf(str.charAt(0));
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            StringBuilder stringBuilder2 = stringBuilder.append(string4);
            String string5 = str.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            string2 = stringBuilder2.append(string5).toString();
        } else {
            string2 = '_' + str;
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final Name getScriptNameForFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Name name = Name.identifier(NameUtils.getPackagePartClassNamePrefix(StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)filePath, (char)'/', null, (int)2, null), (char)'.', null, (int)2, null)));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(NameUtils.get\u2026ubstringBeforeLast('.')))");
        return name;
    }

    @JvmStatic
    public static final boolean hasName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return !Intrinsics.areEqual((Object)name, (Object)SpecialNames.NO_NAME_PROVIDED) && !Intrinsics.areEqual((Object)name, (Object)SpecialNames.ANONYMOUS);
    }
}

