/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.serialization.deserialization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.internal.descriptors.ModuleDescriptor;
import kotlinx.metadata.internal.descriptors.PackageFragmentDescriptor;
import kotlinx.metadata.internal.metadata.ProtoBuf;
import kotlinx.metadata.internal.metadata.builtins.BuiltInsBinaryVersion;
import kotlinx.metadata.internal.metadata.deserialization.BinaryVersion;
import kotlinx.metadata.internal.metadata.deserialization.NameResolver;
import kotlinx.metadata.internal.metadata.deserialization.NameResolverImpl;
import kotlinx.metadata.internal.name.ClassId;
import kotlinx.metadata.internal.name.FqName;
import kotlinx.metadata.internal.name.Name;
import kotlinx.metadata.internal.resolve.scopes.ChainedMemberScope;
import kotlinx.metadata.internal.resolve.scopes.MemberScope;
import kotlinx.metadata.internal.serialization.deserialization.DeserializationComponents;
import kotlinx.metadata.internal.serialization.deserialization.DeserializedPackageFragment;
import kotlinx.metadata.internal.serialization.deserialization.KotlinMetadataFinder;
import kotlinx.metadata.internal.serialization.deserialization.MetadataClassDataFinder;
import kotlinx.metadata.internal.serialization.deserialization.MetadataPackageFragment;
import kotlinx.metadata.internal.serialization.deserialization.MetadataPartProvider;
import kotlinx.metadata.internal.serialization.deserialization.MetadataUtilKt;
import kotlinx.metadata.internal.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import kotlinx.metadata.internal.storage.NotNullLazyValue;
import kotlinx.metadata.internal.storage.StorageManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkotlinx/metadata/internal/serialization/deserialization/MetadataPackageFragment;", "Lkotlinx/metadata/internal/serialization/deserialization/DeserializedPackageFragment;", "fqName", "Lkotlinx/metadata/internal/name/FqName;", "storageManager", "Lkotlinx/metadata/internal/storage/StorageManager;", "module", "Lkotlinx/metadata/internal/descriptors/ModuleDescriptor;", "metadataPartProvider", "Lkotlinx/metadata/internal/serialization/deserialization/MetadataPartProvider;", "finder", "Lkotlinx/metadata/internal/serialization/deserialization/KotlinMetadataFinder;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPartProvider;Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;)V", "classDataFinder", "Lkotlinx/metadata/internal/serialization/deserialization/MetadataClassDataFinder;", "getClassDataFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder;", "components", "Lkotlinx/metadata/internal/serialization/deserialization/DeserializationComponents;", "memberScope", "Lkotlinx/metadata/internal/storage/NotNullLazyValue;", "Lkotlinx/metadata/internal/resolve/scopes/MemberScope;", "computeMemberScope", "getMemberScope", "hasTopLevelClass", "", "name", "Lkotlinx/metadata/internal/name/Name;", "initialize", "", "Companion", "deserialization"})
public final class MetadataPackageFragment
extends DeserializedPackageFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetadataPartProvider metadataPartProvider;
    @NotNull
    private final KotlinMetadataFinder finder;
    @NotNull
    private final MetadataClassDataFinder classDataFinder;
    private DeserializationComponents components;
    @NotNull
    private final NotNullLazyValue<MemberScope> memberScope;
    @NotNull
    public static final String METADATA_FILE_EXTENSION = "kotlin_metadata";
    @NotNull
    public static final String DOT_METADATA_FILE_EXTENSION = ".kotlin_metadata";

    public MetadataPackageFragment(@NotNull FqName fqName, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor module, @NotNull MetadataPartProvider metadataPartProvider, @NotNull KotlinMetadataFinder finder) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)metadataPartProvider, (String)"metadataPartProvider");
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        super(fqName, storageManager, module);
        this.metadataPartProvider = metadataPartProvider;
        this.finder = finder;
        this.classDataFinder = new MetadataClassDataFinder(this.finder);
        this.memberScope = storageManager.createLazyValue((Function0)new Function0<MemberScope>(this){
            final /* synthetic */ MetadataPackageFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MemberScope invoke() {
                return MetadataPackageFragment.access$computeMemberScope(this.this$0);
            }
        });
    }

    @Override
    @NotNull
    public MetadataClassDataFinder getClassDataFinder() {
        return this.classDataFinder;
    }

    @Override
    public void initialize(@NotNull DeserializationComponents components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.components = components;
    }

    private final MemberScope computeMemberScope() {
        Object object;
        String string2 = this.getFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        List<String> packageParts = this.metadataPartProvider.findMetadataPackageParts(string2);
        ArrayList<DeserializedPackageMemberScope> scopes = new ArrayList<DeserializedPackageMemberScope>();
        for (String partName : packageParts) {
            InputStream stream;
            if (this.finder.findMetadata(new ClassId(this.getFqName(), Name.identifier(partName))) == null) continue;
            object = MetadataUtilKt.readProto(stream);
            ProtoBuf.PackageFragment proto = (ProtoBuf.PackageFragment)object.component1();
            NameResolverImpl nameResolver2 = (NameResolverImpl)object.component2();
            BuiltInsBinaryVersion version = (BuiltInsBinaryVersion)object.component3();
            PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)this;
            ProtoBuf.Package package_ = proto.getPackage();
            Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"getPackage(...)");
            NameResolver nameResolver3 = nameResolver2;
            BinaryVersion binaryVersion = version;
            DeserializationComponents deserializationComponents = this.components;
            if (deserializationComponents == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"components");
                deserializationComponents = null;
            }
            scopes.add(new DeserializedPackageMemberScope(packageFragmentDescriptor, package_, nameResolver3, binaryVersion, null, deserializationComponents, "scope with top-level callables and type aliases (no classes) for package part " + partName + " of " + (Object)((Object)this), (Function0<? extends Collection<Name>>)((Function0)computeMemberScope.1.INSTANCE)));
        }
        ProtoBuf.Package package_ = ProtoBuf.Package.getDefaultInstance();
        ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"getDefaultInstance(...)");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"getDefaultInstance(...)");
        NameResolverImpl nameResolverImpl = new NameResolverImpl(stringTable, qualifiedNameTable);
        BuiltInsBinaryVersion builtInsBinaryVersion = BuiltInsBinaryVersion.INSTANCE;
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            deserializationComponents = null;
        }
        object = deserializationComponents;
        String string3 = "scope for all classes of " + (Object)((Object)this);
        computeMemberScope.3 var8_8 = computeMemberScope.3.INSTANCE;
        scopes.add(new DeserializedPackageMemberScope(this, package_, nameResolverImpl, builtInsBinaryVersion, (DeserializationComponents)object, string3, var8_8){
            final /* synthetic */ MetadataPackageFragment this$0;
            {
                this.this$0 = $receiver;
                PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)$receiver;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super(packageFragmentDescriptor, $super_call_param$1, $super_call_param$2, $super_call_param$3, null, $super_call_param$4, $super_call_param$5, (Function0<? extends Collection<Name>>)((Function0)$super_call_param$6));
            }

            protected boolean hasClass(@NotNull Name name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return this.this$0.hasTopLevelClass(name);
            }

            public boolean definitelyDoesNotContainName(@NotNull Name name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return false;
            }

            @Nullable
            public Set<Name> getClassifierNames() {
                return null;
            }

            @Nullable
            protected Set<Name> getNonDeclaredClassifierNames() {
                return null;
            }
        });
        return ChainedMemberScope.Companion.create(".kotlin_metadata parts scope of " + (Object)((Object)this), (Iterable)scopes);
    }

    @NotNull
    public MemberScope getMemberScope() {
        return (MemberScope)this.memberScope.invoke();
    }

    @Override
    public boolean hasTopLevelClass(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return true;
    }

    public static final /* synthetic */ MemberScope access$computeMemberScope(MetadataPackageFragment $this) {
        return $this.computeMemberScope();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkotlinx/metadata/internal/serialization/deserialization/MetadataPackageFragment$Companion;", "", "()V", "DOT_METADATA_FILE_EXTENSION", "", "METADATA_FILE_EXTENSION", "deserialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

