/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.metadata.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.metadata.klib.KlibModuleMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.SerializedMetadata;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B7\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u001a\u0010\u0007\u001a\u0016\u0012\u0012\u0012\u0010\u0012\b\u0012\u00060\u0006j\u0002`\t0\bj\u0002`\n0\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u0013\u001a\u00060\u0006j\u0002`\t2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\u0014\u001a\u00020\fH\u0016R.\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\f\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\u0006j\u0002`\t0\u000fj\u0002`\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/commonizer/metadata/utils/SerializedMetadataLibraryProvider;", "Lkotlinx/metadata/klib/KlibModuleMetadata$MetadataLibraryProvider;", "serializedMetadata", "Lorg/jetbrains/kotlin/library/SerializedMetadata;", "(Lorg/jetbrains/kotlin/library/SerializedMetadata;)V", "moduleHeaderData", "", "fragments", "", "Lorg/jetbrains/kotlin/commonizer/metadata/utils/FragmentPartContents;", "Lorg/jetbrains/kotlin/commonizer/metadata/utils/ListOfFragmentParts;", "fragmentNames", "", "([BLjava/util/List;Ljava/util/List;)V", "fragmentMap", "", "Lorg/jetbrains/kotlin/commonizer/metadata/utils/MapOfFragmentParts;", "getModuleHeaderData", "()[B", "packageMetadata", "fqName", "partName", "packageMetadataParts", "", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nSerializedMetadataLibraryProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializedMetadataLibraryProvider.kt\norg/jetbrains/kotlin/commonizer/metadata/utils/SerializedMetadataLibraryProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1559#2:57\n1590#2,3:58\n1559#2:61\n1590#2,4:62\n1593#2:66\n*S KotlinDebug\n*F\n+ 1 SerializedMetadataLibraryProvider.kt\norg/jetbrains/kotlin/commonizer/metadata/utils/SerializedMetadataLibraryProvider\n*L\n25#1:57\n25#1:58,3\n33#1:61\n33#1:62,4\n25#1:66\n*E\n"})
public final class SerializedMetadataLibraryProvider
implements KlibModuleMetadata.MetadataLibraryProvider {
    @NotNull
    private final byte[] moduleHeaderData;
    @NotNull
    private final Map<String, Map<String, byte[]>> fragmentMap;

    /*
     * WARNING - void declaration
     */
    public SerializedMetadataLibraryProvider(@NotNull byte[] moduleHeaderData2, @NotNull List<? extends List<byte[]>> fragments2, @NotNull List<String> fragmentNames) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)moduleHeaderData2, (String)"moduleHeaderData");
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        Intrinsics.checkNotNullParameter(fragmentNames, (String)"fragmentNames");
        this.moduleHeaderData = moduleHeaderData2;
        if (!(fragments2.size() == fragmentNames.size())) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        Iterable iterable = fragmentNames;
        SerializedMetadataLibraryProvider serializedMetadataLibraryProvider = this;
        boolean $i$f$mapIndexed = false;
        void var6_8 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv2;
            void fragmentIndex;
            void fragmentName;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string3 = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String fragmentShortName = StringsKt.substringAfterLast$default((String)fragmentName, (char)'.', null, (int)2, null);
            List<byte[]> fragmentParts = fragments2.get((int)fragmentIndex);
            int digitCount = String.valueOf(fragmentParts.size()).length();
            Iterable $this$mapIndexed$iv2 = fragmentParts;
            boolean $i$f$mapIndexed2 = false;
            Iterable iterable2 = $this$mapIndexed$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
            boolean $i$f$mapIndexedTo2 = false;
            int index$iv$iv2 = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                void part;
                void partIndex;
                int n3;
                if ((n3 = index$iv$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                byte[] byArray = (byte[])item$iv$iv2;
                int n4 = n3;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                String partName = StringsKt.padStart((String)String.valueOf((int)partIndex), (int)digitCount, (char)'0') + '_' + fragmentShortName;
                collection2.add(TuplesKt.to((Object)partName, (Object)part));
            }
            Map fragmentPartMap = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            collection.add(TuplesKt.to((Object)fragmentName, (Object)fragmentPartMap));
        }
        serializedMetadataLibraryProvider.fragmentMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public byte[] getModuleHeaderData() {
        return this.moduleHeaderData;
    }

    public SerializedMetadataLibraryProvider(@NotNull SerializedMetadata serializedMetadata) {
        Intrinsics.checkNotNullParameter((Object)serializedMetadata, (String)"serializedMetadata");
        this(serializedMetadata.getModule(), serializedMetadata.getFragments(), serializedMetadata.getFragmentNames());
    }

    @Override
    @NotNull
    public Set<String> packageMetadataParts(@NotNull String fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return ((Map)MapsKt.getValue(this.fragmentMap, (Object)fqName)).keySet();
    }

    @Override
    @NotNull
    public byte[] packageMetadata(@NotNull String fqName, @NotNull String partName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
        return (byte[])MapsKt.getValue((Map)((Map)MapsKt.getValue(this.fragmentMap, (Object)fqName)), (Object)partName);
    }
}

