/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.NativeLibraryLoader;
import org.jetbrains.kotlin.commonizer.NativeLibraryLoadingException;
import org.jetbrains.kotlin.commonizer.cli.CliLoggerAdapterKt;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.SingleFileResolveKt;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.metadata.KlibMetadataMetadataVersionKt;
import org.jetbrains.kotlin.library.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/commonizer/DefaultNativeLibraryLoader;", "Lorg/jetbrains/kotlin/commonizer/NativeLibraryLoader;", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "<init>", "(Lorg/jetbrains/kotlin/util/Logger;)V", "invoke", "Lorg/jetbrains/kotlin/commonizer/konan/NativeLibrary;", "file", "Ljava/io/File;", "kotlin-klib-commonizer"})
public final class DefaultNativeLibraryLoader
implements NativeLibraryLoader {
    @NotNull
    private final Logger logger;

    public DefaultNativeLibraryLoader(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @Override
    @NotNull
    public NativeLibrary invoke(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        try {
            KlibMetadataVersion metadataVersion;
            String string2 = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            KotlinLibrary library = SingleFileResolveKt.resolveSingleFileKlib((org.jetbrains.kotlin.konan.file.File)new org.jetbrains.kotlin.konan.file.File(string2), (Logger)this.logger, (SingleFileKlibResolveStrategy)((SingleFileKlibResolveStrategy)ToolingSingleFileKlibResolveStrategy.INSTANCE));
            if (library.getVersions().getMetadataVersion() == null) {
                CliLoggerAdapterKt.errorAndExitJvmProcess(this.logger, "Library does not have metadata version specified in manifest: " + file2);
                throw null;
            }
            KlibMetadataVersion klibMetadataVersion = metadataVersion = KlibMetadataMetadataVersionKt.getMetadataVersion((KotlinLibrary)library);
            if (!(klibMetadataVersion != null ? klibMetadataVersion.isCompatibleWithCurrentCompilerVersion() : false)) {
                StringBuilder stringBuilder = new StringBuilder().append("\n                Library has incompatible metadata version ");
                Object object = metadataVersion;
                if (object == null) {
                    object = "\"unknown\"";
                }
                CliLoggerAdapterKt.errorAndExitJvmProcess(this.logger, StringsKt.trimIndent((String)stringBuilder.append(object).append(": ").append(file2).append("\n                Please make sure that all libraries passed to commonizer compatible metadata version ").append(KlibMetadataVersion.INSTANCE).append("\n                ").toString()));
                throw null;
            }
            return new NativeLibrary(library);
        }
        catch (Throwable cause) {
            throw new NativeLibraryLoadingException("Failed loading library at " + file2.getPath(), cause);
        }
    }
}

