/*
 * Decompiled with CFR 0.152.
 */
package kotlin.metadata.internal.serialization;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.metadata.internal.builtins.KotlinBuiltIns;
import kotlin.metadata.internal.descriptors.ClassDescriptor;
import kotlin.metadata.internal.descriptors.ClassifierDescriptor;
import kotlin.metadata.internal.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.metadata.internal.descriptors.DeclarationDescriptor;
import kotlin.metadata.internal.descriptors.annotations.AnnotationArgumentVisitor;
import kotlin.metadata.internal.descriptors.annotations.AnnotationDescriptor;
import kotlin.metadata.internal.metadata.ProtoBuf;
import kotlin.metadata.internal.metadata.deserialization.Flags;
import kotlin.metadata.internal.name.ClassId;
import kotlin.metadata.internal.name.Name;
import kotlin.metadata.internal.resolve.constants.AnnotationValue;
import kotlin.metadata.internal.resolve.constants.ArrayValue;
import kotlin.metadata.internal.resolve.constants.BooleanValue;
import kotlin.metadata.internal.resolve.constants.ByteValue;
import kotlin.metadata.internal.resolve.constants.CharValue;
import kotlin.metadata.internal.resolve.constants.ConstantValue;
import kotlin.metadata.internal.resolve.constants.DoubleValue;
import kotlin.metadata.internal.resolve.constants.EnumValue;
import kotlin.metadata.internal.resolve.constants.ErrorValue;
import kotlin.metadata.internal.resolve.constants.FloatValue;
import kotlin.metadata.internal.resolve.constants.IntValue;
import kotlin.metadata.internal.resolve.constants.KClassValue;
import kotlin.metadata.internal.resolve.constants.LongValue;
import kotlin.metadata.internal.resolve.constants.NullValue;
import kotlin.metadata.internal.resolve.constants.ShortValue;
import kotlin.metadata.internal.resolve.constants.StringValue;
import kotlin.metadata.internal.resolve.constants.UByteValue;
import kotlin.metadata.internal.resolve.constants.UIntValue;
import kotlin.metadata.internal.resolve.constants.ULongValue;
import kotlin.metadata.internal.resolve.constants.UShortValue;
import kotlin.metadata.internal.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.metadata.internal.serialization.DescriptorAwareStringTable;
import kotlin.metadata.internal.types.KotlinType;
import kotlin.metadata.internal.types.TypeProjection;
import kotlin.metadata.internal.types.error.ErrorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkotlin/metadata/internal/serialization/AnnotationSerializer;", "", "stringTable", "Lkotlin/metadata/internal/serialization/DescriptorAwareStringTable;", "<init>", "(Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;)V", "serializeAnnotation", "Lkotlin/metadata/internal/metadata/ProtoBuf$Annotation;", "annotation", "Lkotlin/metadata/internal/descriptors/annotations/AnnotationDescriptor;", "getAnnotationClassId", "Lkotlin/metadata/internal/name/ClassId;", "valueProto", "Lkotlin/metadata/internal/metadata/ProtoBuf$Annotation$Argument$Value$Builder;", "constant", "Lkotlin/metadata/internal/resolve/constants/ConstantValue;", "serialization"})
public class AnnotationSerializer {
    @NotNull
    private final DescriptorAwareStringTable stringTable;

    public AnnotationSerializer(@NotNull DescriptorAwareStringTable stringTable) {
        Intrinsics.checkNotNullParameter((Object)stringTable, (String)"stringTable");
        this.stringTable = stringTable;
    }

    @Nullable
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull AnnotationDescriptor annotation) {
        ProtoBuf.Annotation.Builder builder;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        ProtoBuf.Annotation.Builder $this$serializeAnnotation_u24lambda_u240 = builder = ProtoBuf.Annotation.newBuilder();
        boolean bl = false;
        ClassId classId = this.getAnnotationClassId(annotation);
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        $this$serializeAnnotation_u24lambda_u240.setId(this.stringTable.getQualifiedClassNameIndex(classId2));
        for (Map.Entry entry : annotation.getAllValueArguments().entrySet()) {
            Name name = (Name)entry.getKey();
            ConstantValue value = (ConstantValue)entry.getValue();
            ProtoBuf.Annotation.Argument.Builder argument = ProtoBuf.Annotation.Argument.newBuilder();
            String string2 = name.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            argument.setNameId(this.stringTable.getStringIndex(string2));
            argument.setValue(this.valueProto(value));
            $this$serializeAnnotation_u24lambda_u240.addArgument(argument);
        }
        return builder.build();
    }

    @Nullable
    protected ClassId getAnnotationClassId(@NotNull AnnotationDescriptor annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass((AnnotationDescriptor)annotation);
        if (classDescriptor == null) {
            throw new IllegalStateException(("Annotation type is not a class: " + annotation.getType()).toString());
        }
        ClassDescriptor annotationClass = classDescriptor;
        if (ErrorUtils.isError((DeclarationDescriptor)((DeclarationDescriptor)annotationClass))) {
            throw new IllegalStateException(("Unresolved annotation type: " + annotation.getType() + " at " + annotation.getSource().getContainingFile()).toString());
        }
        return DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassifierDescriptor)annotationClass));
    }

    @NotNull
    public final ProtoBuf.Annotation.Argument.Value.Builder valueProto(@NotNull ConstantValue<?> constant) {
        ProtoBuf.Annotation.Argument.Value.Builder builder;
        Intrinsics.checkNotNullParameter(constant, (String)"constant");
        ProtoBuf.Annotation.Argument.Value.Builder $this$valueProto_u24lambda_u241 = builder = ProtoBuf.Annotation.Argument.Value.newBuilder();
        boolean bl = false;
        constant.accept((AnnotationArgumentVisitor)new AnnotationArgumentVisitor<Unit, Unit>($this$valueProto_u24lambda_u241, this){
            final /* synthetic */ ProtoBuf.Annotation.Argument.Value.Builder $this_apply;
            final /* synthetic */ AnnotationSerializer this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            public void visitAnnotationValue(AnnotationValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION);
                this.$this_apply.setAnnotation(this.this$0.serializeAnnotation((AnnotationDescriptor)value.getValue()));
            }

            public void visitArrayValue(ArrayValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ARRAY);
                for (ConstantValue element : (List)value.getValue()) {
                    this.$this_apply.addArrayElement(this.this$0.valueProto(element).build());
                }
            }

            public void visitBooleanValue(BooleanValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN);
                this.$this_apply.setIntValue((Boolean)value.getValue() != false ? 1L : 0L);
            }

            public void visitByteValue(ByteValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
                this.$this_apply.setIntValue(((Number)value.getValue()).byteValue());
            }

            public void visitCharValue(CharValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.CHAR);
                this.$this_apply.setIntValue(((Character)value.getValue()).charValue());
            }

            public void visitDoubleValue(DoubleValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.DOUBLE);
                this.$this_apply.setDoubleValue(((Number)value.getValue()).doubleValue());
            }

            public void visitEnumValue(EnumValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ENUM);
                this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getQualifiedClassNameIndex(value.getEnumClassId()));
                DescriptorAwareStringTable descriptorAwareStringTable = AnnotationSerializer.access$getStringTable$p(this.this$0);
                String string2 = value.getEnumEntryName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                this.$this_apply.setEnumValueId(descriptorAwareStringTable.getStringIndex(string2));
            }

            public void visitErrorValue(ErrorValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                throw new UnsupportedOperationException("Error value: " + value);
            }

            public void visitFloatValue(FloatValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.FLOAT);
                this.$this_apply.setFloatValue(((Number)value.getValue()).floatValue());
            }

            public void visitIntValue(IntValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
                this.$this_apply.setIntValue(((Number)value.getValue()).intValue());
            }

            public void visitKClassValue(KClassValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.CLASS);
                KClassValue.Value classValue = (KClassValue.Value)value.getValue();
                if (classValue instanceof KClassValue.Value.NormalClass) {
                    this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getQualifiedClassNameIndex(((KClassValue.Value.NormalClass)classValue).getClassId()));
                    if (((KClassValue.Value.NormalClass)classValue).getArrayDimensions() > 0) {
                        this.$this_apply.setArrayDimensionCount(((KClassValue.Value.NormalClass)classValue).getArrayDimensions());
                    }
                } else if (classValue instanceof KClassValue.Value.LocalClass) {
                    int arrayDimensions = 0;
                    KotlinType type2 = ((KClassValue.Value.LocalClass)classValue).getType();
                    while (KotlinBuiltIns.isArray((KotlinType)type2)) {
                        ++arrayDimensions;
                        type2 = ((TypeProjection)CollectionsKt.single((List)type2.getArguments())).getType();
                    }
                    ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    if (classDescriptor == null) {
                        throw new IllegalStateException(("Type parameters are not allowed in class literal annotation arguments: " + classValue).toString());
                    }
                    ClassDescriptor descriptor = classDescriptor;
                    this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getFqNameIndex((ClassifierDescriptorWithTypeParameters)descriptor));
                    if (arrayDimensions > 0) {
                        this.$this_apply.setArrayDimensionCount(arrayDimensions);
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }

            public void visitLongValue(LongValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
                this.$this_apply.setIntValue(((Number)value.getValue()).longValue());
            }

            public void visitNullValue(NullValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                throw new UnsupportedOperationException("Null should not appear in annotation arguments");
            }

            public void visitShortValue(ShortValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
                this.$this_apply.setIntValue(((Number)value.getValue()).shortValue());
            }

            public void visitStringValue(StringValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.STRING);
                this.$this_apply.setStringValue(AnnotationSerializer.access$getStringTable$p(this.this$0).getStringIndex((String)value.getValue()));
            }

            public void visitUByteValue(UByteValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
                this.$this_apply.setIntValue(((Number)value.getValue()).byteValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitUShortValue(UShortValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
                this.$this_apply.setIntValue(((Number)value.getValue()).shortValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitUIntValue(UIntValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
                this.$this_apply.setIntValue(((Number)value.getValue()).intValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitULongValue(ULongValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
                this.$this_apply.setIntValue(((Number)value.getValue()).longValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }
        }, (Object)Unit.INSTANCE);
        ProtoBuf.Annotation.Argument.Value.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
        return builder2;
    }

    public static final /* synthetic */ DescriptorAwareStringTable access$getStringTable$p(AnnotationSerializer $this) {
        return $this.stringTable;
    }
}

