/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.commonizer.core.AssociativeCommonizer;
import org.jetbrains.kotlin.commonizer.core.CommonizerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/AssociativeCommonizerAdapter;", "T", "", "Lorg/jetbrains/kotlin/commonizer/core/AbstractStandardCommonizer;", "commonizer", "Lorg/jetbrains/kotlin/commonizer/core/AssociativeCommonizer;", "<init>", "(Lorg/jetbrains/kotlin/commonizer/core/AssociativeCommonizer;)V", "_result", "Ljava/lang/Object;", "commonizationResult", "()Ljava/lang/Object;", "initialize", "", "first", "(Ljava/lang/Object;)V", "doCommonizeWith", "", "next", "(Ljava/lang/Object;)Z", "kotlin-klib-commonizer"})
public class AssociativeCommonizerAdapter<T>
extends AbstractStandardCommonizer<T, T> {
    @NotNull
    private final AssociativeCommonizer<T> commonizer;
    @Nullable
    private T _result;

    public AssociativeCommonizerAdapter(@NotNull AssociativeCommonizer<T> commonizer) {
        Intrinsics.checkNotNullParameter(commonizer, (String)"commonizer");
        this.commonizer = commonizer;
    }

    @Override
    @NotNull
    protected T commonizationResult() {
        T t = this._result;
        if (t == null) {
            CommonizerKt.failInEmptyState(this);
            throw new KotlinNothingValueException();
        }
        return t;
    }

    @Override
    protected void initialize(@NotNull T first) {
        Intrinsics.checkNotNullParameter(first, (String)"first");
    }

    @Override
    protected boolean doCommonizeWith(@NotNull T next) {
        Intrinsics.checkNotNullParameter(next, (String)"next");
        T currentResult = this._result;
        if (currentResult == null) {
            this._result = next;
            return true;
        }
        this._result = this.commonizer.commonize(currentResult, next);
        return this._result != null;
    }
}

