/*
 * Decompiled with CFR 0.152.
 */
package kotlin.metadata.internal.serialization;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.metadata.internal.metadata.ProtoBuf;
import kotlin.metadata.internal.metadata.serialization.Interner;
import kotlin.metadata.internal.metadata.serialization.StringTable;
import kotlin.metadata.internal.name.ClassId;
import kotlin.metadata.internal.name.FqName;
import kotlin.metadata.internal.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lkotlin/metadata/internal/serialization/SerializableStringTable;", "Lkotlin/metadata/internal/metadata/serialization/StringTable;", "<init>", "()V", "strings", "Lkotlin/metadata/internal/metadata/serialization/Interner;", "", "qualifiedNames", "Lkotlin/metadata/internal/serialization/SerializableStringTable$FqNameProto;", "addString", "", "string", "addQualifiedName", "qualifiedName", "Lkotlin/metadata/internal/metadata/ProtoBuf$QualifiedNameTable$QualifiedName;", "getStringIndex", "", "getQualifiedClassNameIndex", "className", "isLocal", "", "getClassIdIndex", "classId", "Lkotlin/metadata/internal/name/ClassId;", "getPackageFqNameIndexByString", "fqName", "getPackageFqNameIndex", "Lkotlin/metadata/internal/name/FqName;", "buildProto", "Lkotlin/Pair;", "Lkotlin/metadata/internal/metadata/ProtoBuf$StringTable;", "Lkotlin/metadata/internal/metadata/ProtoBuf$QualifiedNameTable;", "FqNameProto", "serialization"})
@SourceDebugExtension(value={"SMAP\nStringTableImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringTableImpl.kt\norg/jetbrains/kotlin/serialization/SerializableStringTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public class SerializableStringTable
implements StringTable {
    @NotNull
    private final Interner<String> strings = new Interner(null, 1, null);
    @NotNull
    private final Interner<FqNameProto> qualifiedNames = new Interner(null, 1, null);

    public final void addString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.strings.intern(string);
    }

    public final void addQualifiedName(@NotNull ProtoBuf.QualifiedNameTable.QualifiedName qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = qualifiedName.toBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"toBuilder(...)");
        this.qualifiedNames.intern(new FqNameProto(builder));
    }

    @Override
    public int getStringIndex(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.strings.intern(string);
    }

    @Override
    public int getQualifiedClassNameIndex(@NotNull String className, boolean isLocal) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return this.getClassIdIndex(ClassId.Companion.fromString(className, isLocal));
    }

    /*
     * WARNING - void declaration
     */
    public final int getClassIdIndex(@NotNull ClassId classId) {
        int n;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
        builder.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder2 = builder;
        ClassId classId2 = classId.getOuterClassId();
        if (classId2 != null) {
            void p0;
            ClassId classId3 = classId2;
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder3 = builder2;
            boolean bl = false;
            int n2 = this.getClassIdIndex((ClassId)p0);
            builder2 = builder3;
            n = n2;
        } else {
            n = this.getPackageFqNameIndex(classId.getPackageFqName());
        }
        builder2.setParentQualifiedName(n);
        String string = classId.getShortClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        builder.setShortName(this.getStringIndex(string));
        Intrinsics.checkNotNull((Object)builder);
        return this.qualifiedNames.intern(new FqNameProto(builder));
    }

    @Override
    public int getPackageFqNameIndexByString(@NotNull String fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return this.getPackageFqNameIndex(new FqName(fqName));
    }

    public final int getPackageFqNameIndex(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        int result = -1;
        for (Name segment : fqName.pathSegments()) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
            String string = segment.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            builder.setShortName(this.getStringIndex(string));
            if (result != -1) {
                builder.setParentQualifiedName(result);
            }
            Intrinsics.checkNotNull((Object)builder);
            result = this.qualifiedNames.intern(new FqNameProto(builder));
        }
        return result;
    }

    @NotNull
    public final Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> buildProto() {
        ProtoBuf.StringTable.Builder strings2 = ProtoBuf.StringTable.newBuilder();
        for (String simpleName : this.strings.getAllInternedObjects()) {
            strings2.addString(simpleName);
        }
        ProtoBuf.QualifiedNameTable.Builder qualifiedNames = ProtoBuf.QualifiedNameTable.newBuilder();
        for (FqNameProto fqName : this.qualifiedNames.getAllInternedObjects()) {
            qualifiedNames.addQualifiedName(fqName.getFqName());
        }
        return new Pair((Object)strings2.build(), (Object)qualifiedNames.build());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lkotlin/metadata/internal/serialization/SerializableStringTable$FqNameProto;", "", "fqName", "Lkotlin/metadata/internal/metadata/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;", "<init>", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;)V", "getFqName", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;", "hashCode", "", "equals", "", "other", "serialization"})
    private static final class FqNameProto {
        @NotNull
        private final ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName;

        public FqNameProto(@NotNull ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName) {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            this.fqName = fqName;
        }

        @NotNull
        public final ProtoBuf.QualifiedNameTable.QualifiedName.Builder getFqName() {
            return this.fqName;
        }

        public int hashCode() {
            int result = 13;
            result = 31 * result + this.fqName.getParentQualifiedName();
            result = 31 * result + this.fqName.getShortName();
            result = 31 * result + this.fqName.getKind().hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null || !(other instanceof FqNameProto)) {
                return false;
            }
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder otherFqName = ((FqNameProto)other).fqName;
            return this.fqName.getParentQualifiedName() == otherFqName.getParentQualifiedName() && this.fqName.getShortName() == otherFqName.getShortName() && this.fqName.getKind() == otherFqName.getKind();
        }
    }
}

