/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.filter;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.filter.OSGiFilter;

public abstract class MultiOperatorFilter
extends OSGiFilter {
    private List<OSGiFilter> subFilters = new ArrayList<OSGiFilter>();

    public MultiOperatorFilter() {
    }

    public MultiOperatorFilter(OSGiFilter[] filters) {
        for (int i = 0; i < filters.length; ++i) {
            OSGiFilter filter2 = filters[i];
            this.add(filter2);
        }
    }

    protected abstract char operator();

    @Override
    public void append(StringBuffer builder) {
        builder.append('(');
        builder.append(this.operator());
        for (OSGiFilter filter2 : this.subFilters) {
            filter2.append(builder);
        }
        builder.append(')');
    }

    public void add(OSGiFilter subFilter2) {
        this.subFilters.add(subFilter2);
    }

    public List<OSGiFilter> getSubFilters() {
        return this.subFilters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (OSGiFilter subFilter : this.subFilters) {
            result = 31 * result + (subFilter == null ? 0 : subFilter.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiOperatorFilter)) {
            return false;
        }
        MultiOperatorFilter other = (MultiOperatorFilter)obj;
        if (this.subFilters == null) {
            if (other.subFilters != null) {
                return false;
            }
        } else {
            if (other.subFilters == null) {
                return false;
            }
            if (this.subFilters.size() != other.subFilters.size()) {
                return false;
            }
            if (!this.subFilters.containsAll(other.subFilters)) {
                return false;
            }
        }
        return true;
    }
}

