/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.cli;

import java.util.ArrayList;
import java.util.ListIterator;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.cli.ParseException;

public class Option {
    private String name;
    private String[] args;
    private String description;
    private boolean required;
    private boolean countArgs;
    private boolean deprecated;

    Option(String name, String[] args, String description, boolean required, boolean countArgs, boolean deprecated) {
        this.name = name;
        this.args = args;
        this.description = description;
        this.required = required;
        this.countArgs = countArgs;
        this.deprecated = deprecated;
        if (required) {
            throw new UnsupportedOperationException("required option not supported yet");
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isCountArgs() {
        return this.countArgs;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    String[] parse(ListIterator<String> iterator) throws ParseException {
        if (this.isCountArgs()) {
            String[] values2 = new String[this.args.length];
            for (int i = 0; i < values2.length; ++i) {
                if (!iterator.hasNext()) {
                    this.missingArgument(i);
                }
                values2[i] = iterator.next();
                if (!values2[i].startsWith("-")) continue;
                this.missingArgument(i);
            }
            return values2;
        }
        ArrayList<String> values3 = new ArrayList<String>();
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (value.startsWith("-")) {
                iterator.previous();
                break;
            }
            values3.add(value);
        }
        return values3.toArray(new String[values3.size()]);
    }

    private void missingArgument(int i) throws ParseException {
        if (i == 0) {
            throw new ParseException("no argument for: " + this.name);
        }
        throw new ParseException("missing argument for: " + this.name + ". Expected: " + this.getArgsSpec());
    }

    public String getSpec() {
        return "-" + this.name + " " + this.getArgsSpec();
    }

    private String getArgsSpec() {
        if (this.args.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String arg : this.args) {
            sb.append("<").append(arg).append("> ");
        }
        return sb.toString();
    }
}

