/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.impl;

import java.io.File;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 0}, k=2, xi=50, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u001e\u0010\r\u001a\u0004\u0018\u00010\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u0018\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"FILE_PROTOCOL", "", "JAR_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "getResourcePathForClass", "Ljava/io/File;", "aClass", "Ljava/lang/Class;", "getResourceRoot", "context", "path", "splitJarUrl", "Lkotlin/Pair;", "url", "tryGetResourcePathForClass", "tryGetResourcePathForClassByName", "name", "classLoader", "Ljava/lang/ClassLoader;", "toContainingJarOrNull", "toFileOrNull", "kotlin-scripting-jvm"})
public final class PathUtilKt {
    @NotNull
    private static final String JAR_PROTOCOL = "jar";
    @NotNull
    private static final String FILE_PROTOCOL = "file";
    @NotNull
    private static final String JAR_SEPARATOR = "!/";
    @NotNull
    private static final String SCHEME_SEPARATOR = "://";

    @Nullable
    public static final String getResourceRoot(@NotNull Class<?> context, @NotNull String path) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URL url = context.getResource(path);
        if (url == null) {
            String string = path;
            int n = 1;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            url = ClassLoader.getSystemResource(string2);
        }
        return url != null ? PathUtilKt.extractRoot(url, path) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        String string;
        String string2;
        Pair<String, String> pair;
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, (char)'\\', (boolean)false, (int)2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual((Object)protocol, (Object)FILE_PROTOCOL)) {
            pair = PathUtilKt.toFileOrNull(resourceURL);
            Intrinsics.checkNotNull((Object)pair);
            String path = pair.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            String testPath = StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            String testResourcePath = StringsKt.replace$default((String)resourcePath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            if (StringsKt.endsWith((String)testPath, (String)testResourcePath, (boolean)true)) {
                String string3 = path;
                int n = 0;
                int n2 = path.length() - resourcePath.length();
                boolean bl = false;
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                resultPath = string4;
            }
        } else if (Intrinsics.areEqual((Object)protocol, (Object)JAR_PROTOCOL)) {
            Pair<String, String> paths;
            pair = resourceURL.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"resourceURL.file");
            pair = paths = PathUtilKt.splitJarUrl((String)pair);
            if ((pair == null ? null : (String)pair.getFirst()) != null) {
                resultPath = new File((String)paths.getFirst()).getCanonicalPath();
            }
        }
        if ((string2 = resultPath) == null) {
            string = null;
        } else {
            pair = (Pair<String, String>)new char[1];
            pair[0] = (Pair<String, String>)File.separatorChar;
            string = StringsKt.trimEnd(string2, pair);
        }
        return string;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block12: {
            Integer n;
            Object object = StringsKt.indexOf$default((CharSequence)url, (String)JAR_SEPARATOR, (int)0, (boolean)false, (int)6, null);
            int n2 = 0;
            int n3 = 0;
            int it = ((Number)object).intValue();
            boolean bl = false;
            Integer n4 = n = it >= 0 ? object : null;
            if (n == null) {
                return null;
            }
            int pivot = n;
            object = url;
            n2 = pivot + 2;
            n3 = 0;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object2).substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            resourcePath = string;
            String string2 = url;
            n3 = 0;
            int n5 = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n3, pivot);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            jarPath = string4;
            if (StringsKt.startsWith$default((String)jarPath, (String)"jar:", (boolean)false, (int)2, null)) {
                string2 = jarPath;
                n3 = JAR_PROTOCOL.length() + 1;
                n5 = 0;
                String string5 = string2;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n3);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                jarPath = string6;
            }
            if (StringsKt.startsWith$default((String)jarPath, (String)FILE_PROTOCOL, (boolean)false, (int)2, null)) {
                try {
                    File file = PathUtilKt.toFileOrNull(new URL(jarPath));
                    Intrinsics.checkNotNull((Object)file);
                    string2 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"URL(jarPath).toFileOrNull()!!.path");
                    jarPath = StringsKt.replace$default((String)string2, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                }
                catch (Exception e) {
                    String string7 = jarPath;
                    n5 = FILE_PROTOCOL.length();
                    boolean bl2 = false;
                    String string8 = string7;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.substring(n5);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                    jarPath = string9;
                    if (StringsKt.startsWith$default((String)jarPath, (String)SCHEME_SEPARATOR, (boolean)false, (int)2, null)) {
                        string7 = jarPath;
                        n5 = SCHEME_SEPARATOR.length();
                        bl2 = false;
                        String string10 = string7;
                        if (string10 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string11 = string10.substring(n5);
                        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.String).substring(startIndex)");
                        jarPath = string11;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, (char)':', (boolean)false, (int)2, null)) break block12;
                    string7 = jarPath;
                    n5 = 1;
                    bl2 = false;
                    String string12 = string7;
                    if (string12 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string13 = string12.substring(n5);
                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"(this as java.lang.String).substring(startIndex)");
                    jarPath = string13;
                }
            }
        }
        return new Pair((Object)jarPath, (Object)resourcePath);
    }

    @Nullable
    public static final File tryGetResourcePathForClass(@NotNull Class<?> aClass) {
        File file;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        StringBuilder stringBuilder = new StringBuilder().append('/');
        String string = aClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aClass.name");
        String path = stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
        string = PathUtilKt.getResourceRoot(aClass, path);
        if (string == null) {
            file = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            file = new File(it).getAbsoluteFile();
        }
        return file;
    }

    @NotNull
    public static final File getResourcePathForClass(@NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        File file = PathUtilKt.tryGetResourcePathForClass(aClass);
        if (file == null) {
            throw new IllegalStateException("Resource for class: " + aClass.getName() + " not found");
        }
        return file;
    }

    @Nullable
    public static final File tryGetResourcePathForClassByName(@NotNull String name, @NotNull ClassLoader classLoader) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        try {
            File file;
            serializable = classLoader.loadClass(name);
            if (serializable == null) {
                file = null;
            } else {
                Serializable serializable2 = serializable;
                boolean bl = false;
                boolean bl2 = false;
                Serializable p0 = serializable2;
                boolean bl3 = false;
                file = PathUtilKt.tryGetResourcePathForClass(p0);
            }
            serializable = file;
        }
        catch (ClassNotFoundException _) {
            serializable = null;
        }
        catch (NoClassDefFoundError _) {
            serializable = null;
        }
        return serializable;
    }

    @Nullable
    public static final File toFileOrNull(@NotNull URL $this$toFileOrNull) {
        File file;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)$this$toFileOrNull, (String)"<this>");
        try {
            serializable = new File($this$toFileOrNull.toURI());
        }
        catch (IllegalArgumentException e) {
            serializable = null;
        }
        catch (URISyntaxException e) {
            serializable = null;
        }
        File file2 = serializable;
        if (file2 == null) {
            serializable = $this$toFileOrNull;
            boolean bl = false;
            boolean bl2 = false;
            Serializable $this$toFileOrNull_u24lambda_u2d2 = serializable;
            boolean bl3 = false;
            file = !Intrinsics.areEqual((Object)((URL)$this$toFileOrNull_u24lambda_u2d2).getProtocol(), (Object)FILE_PROTOCOL) ? null : new File(((URL)$this$toFileOrNull_u24lambda_u2d2).getFile());
        } else {
            file = file2;
        }
        return file;
    }

    @Nullable
    public static final File toContainingJarOrNull(@NotNull URL $this$toContainingJarOrNull) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$toContainingJarOrNull, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$toContainingJarOrNull.getProtocol(), (Object)JAR_PROTOCOL)) {
            JarURLConnection jarURLConnection;
            Object object = $this$toContainingJarOrNull.openConnection();
            JarURLConnection jarURLConnection2 = jarURLConnection = object instanceof JarURLConnection ? (JarURLConnection)object : null;
            file = jarURLConnection == null ? null : ((object = jarURLConnection.getJarFileURL()) == null ? null : PathUtilKt.toFileOrNull((URL)object));
        } else {
            file = null;
        }
        return file;
    }
}

