/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;

public final class AuthenticationContext
implements Closeable {
    private final RepositorySystemSession session;
    private final RemoteRepository repository;
    private final Proxy proxy;
    private final Authentication auth;
    private final Map<String, Object> authData;
    private boolean fillingAuthData;

    public static AuthenticationContext forRepository(RepositorySystemSession session, RemoteRepository repository) {
        return AuthenticationContext.newInstance(session, repository, null, repository.getAuthentication());
    }

    public static AuthenticationContext forProxy(RepositorySystemSession session, RemoteRepository repository) {
        Proxy proxy;
        return AuthenticationContext.newInstance(session, repository, proxy, (proxy = repository.getProxy()) != null ? proxy.getAuthentication() : null);
    }

    private static AuthenticationContext newInstance(RepositorySystemSession session, RemoteRepository repository, Proxy proxy, Authentication auth) {
        if (auth == null) {
            return null;
        }
        return new AuthenticationContext(session, repository, proxy, auth);
    }

    private AuthenticationContext(RepositorySystemSession session, RemoteRepository repository, Proxy proxy, Authentication auth) {
        this.session = Objects.requireNonNull(session, "repository system session cannot be null");
        this.repository = repository;
        this.proxy = proxy;
        this.auth = auth;
        this.authData = new HashMap<String, Object>();
    }

    public String get(String key) {
        return this.get(key, null, String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String key, Map<String, String> data, Class<T> type) {
        Object value;
        Objects.requireNonNull(key, "authentication key cannot be null");
        if (key.length() == 0) {
            throw new IllegalArgumentException("authentication key cannot be empty");
        }
        Map<String, Object> map = this.authData;
        synchronized (map) {
            value = this.authData.get(key);
            if (value == null && !this.authData.containsKey(key) && !this.fillingAuthData) {
                if (this.auth != null) {
                    try {
                        this.fillingAuthData = true;
                        this.auth.fill(this, key, data);
                    }
                    finally {
                        this.fillingAuthData = false;
                    }
                    value = this.authData.get(key);
                }
                if (value == null) {
                    this.authData.put(key, value);
                }
            }
        }
        return this.convert(value, type);
    }

    private <T> T convert(Object value, Class<T> type) {
        if (!type.isInstance(value)) {
            if (String.class.equals(type)) {
                if (value instanceof File) {
                    value = ((File)value).getPath();
                } else if (value instanceof char[]) {
                    value = new String((char[])value);
                }
            } else if (File.class.equals(type)) {
                if (value instanceof String) {
                    value = new File((String)value);
                }
            } else if (char[].class.equals(type) && value instanceof String) {
                value = ((String)value).toCharArray();
            }
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object value) {
        Objects.requireNonNull(key, "authentication key cannot be null");
        if (key.length() == 0) {
            throw new IllegalArgumentException("authentication key cannot be empty");
        }
        Map<String, Object> map = this.authData;
        synchronized (map) {
            Object oldValue = this.authData.put(key, value);
            if (oldValue instanceof char[]) {
                Arrays.fill((char[])oldValue, '\u0000');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<String, Object> map = this.authData;
        synchronized (map) {
            for (Object value : this.authData.values()) {
                if (!(value instanceof char[])) continue;
                Arrays.fill((char[])value, '\u0000');
            }
            this.authData.clear();
        }
    }

    public static void close(AuthenticationContext context) {
        if (context != null) {
            context.close();
        }
    }
}

