/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transfer;

import java.io.File;
import org.eclipse.aether.RequestTrace;

public final class TransferResource {
    private final String repositoryId;
    private final String repositoryUrl;
    private final String resourceName;
    private final File file;
    private final long startTime;
    private final RequestTrace trace;
    private long contentLength = -1L;
    private long resumeOffset;

    @Deprecated
    public TransferResource(String repositoryUrl, String resourceName, File file, RequestTrace trace) {
        this(null, repositoryUrl, resourceName, file, trace);
    }

    public TransferResource(String repositoryId, String repositoryUrl, String resourceName, File file, RequestTrace trace) {
        this.repositoryId = repositoryId == null || repositoryId.length() <= 0 ? "" : repositoryId;
        this.repositoryUrl = repositoryUrl == null || repositoryUrl.length() <= 0 ? "" : (repositoryUrl.endsWith("/") ? repositoryUrl : repositoryUrl + '/');
        this.resourceName = resourceName == null || resourceName.length() <= 0 ? "" : (resourceName.startsWith("/") ? resourceName.substring(1) : resourceName);
        this.file = file;
        this.trace = trace;
        this.startTime = System.currentTimeMillis();
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public File getFile() {
        return this.file;
    }

    public TransferResource setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public TransferResource setResumeOffset(long resumeOffset) {
        if (resumeOffset < 0L) {
            throw new IllegalArgumentException("resume offset cannot be negative");
        }
        this.resumeOffset = resumeOffset;
        return this;
    }

    public String toString() {
        return this.getRepositoryUrl() + this.getResourceName() + " <> " + this.getFile();
    }
}

