/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.artifact;

import org.eclipse.aether.artifact.Artifact;

public final class ArtifactIdUtils {
    public static String toVersionlessId(Artifact artifact) {
        String id = null;
        if (artifact != null) {
            id = ArtifactIdUtils.toVersionlessId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier());
        }
        return id;
    }

    public static String toVersionlessId(String groupId, String artifactId, String extension, String classifier) {
        return ArtifactIdUtils.concat(groupId, artifactId, extension, classifier).toString();
    }

    private static StringBuilder concat(String groupId, String artifactId, String extension, String classifier) {
        StringBuilder buffer = new StringBuilder(128);
        if (groupId != null) {
            buffer.append(groupId);
        }
        buffer.append(':');
        if (artifactId != null) {
            buffer.append(artifactId);
        }
        buffer.append(':');
        if (extension != null) {
            buffer.append(extension);
        }
        if (classifier != null && classifier.length() > 0) {
            buffer.append(':').append(classifier);
        }
        return buffer;
    }
}

