/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.sisu.bean.BeanBinder;
import org.eclipse.sisu.bean.BeanInjector;
import org.eclipse.sisu.bean.BeanProperties;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.PropertyBinder;
import org.eclipse.sisu.bean.PropertyBinding;
import org.jetbrains.kotlin.com.google.inject.Inject;
import org.jetbrains.kotlin.com.google.inject.ProvisionException;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.spi.TypeEncounter;
import org.jetbrains.kotlin.com.google.inject.spi.TypeListener;

public final class BeanListener
implements TypeListener {
    private final BeanBinder beanBinder;

    public BeanListener(BeanBinder beanBinder) {
        this.beanBinder = beanBinder;
    }

    public <B> void hear(TypeLiteral<B> type, TypeEncounter<B> encounter) {
        PropertyBinder propertyBinder = this.beanBinder.bindBean(type, encounter);
        if (propertyBinder == null) {
            return;
        }
        ArrayList<PropertyBinding> bindings = new ArrayList<PropertyBinding>();
        HashSet<String> visited = new HashSet<String>();
        for (BeanProperty<Object> property : new BeanProperties(type.getRawType())) {
            String name;
            if (property.getAnnotation(javax.inject.Inject.class) != null || property.getAnnotation(Inject.class) != null || !visited.add(name = property.getName())) continue;
            try {
                PropertyBinding binding = propertyBinder.bindProperty(property);
                if (binding == PropertyBinder.LAST_BINDING) break;
                if (binding != null) {
                    bindings.add(binding);
                    continue;
                }
                visited.remove(name);
            }
            catch (RuntimeException e) {
                encounter.addError(new ProvisionException("Error binding: " + property, e));
            }
        }
        if (bindings.size() > 0) {
            encounter.register(new BeanInjector(bindings));
        }
    }
}

