/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import java.util.Arrays;
import org.eclipse.sisu.wire.ElementAnalyzer;
import org.eclipse.sisu.wire.FileTypeConverter;
import org.eclipse.sisu.wire.LocatorWiring;
import org.eclipse.sisu.wire.URLTypeConverter;
import org.eclipse.sisu.wire.Wiring;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.spi.Element;
import org.jetbrains.kotlin.com.google.inject.spi.Elements;

public final class WireModule
implements Module {
    static final Module[] CONVERTERS = new Module[]{new FileTypeConverter(), new URLTypeConverter()};
    private final Iterable<Module> modules;
    private Strategy strategy = Strategy.DEFAULT;

    public WireModule(Module ... modules) {
        this(Arrays.asList(modules));
    }

    public WireModule(Iterable<Module> modules) {
        this.modules = modules;
    }

    public Module with(Strategy _strategy) {
        this.strategy = _strategy;
        return this;
    }

    @Override
    public void configure(Binder binder) {
        ElementAnalyzer analyzer = new ElementAnalyzer(binder);
        for (Element e : Elements.getElements(this.modules)) {
            e.acceptVisitor(analyzer);
        }
        analyzer.apply(this.strategy);
    }

    public static interface Strategy {
        public static final Strategy DEFAULT = new Strategy(){

            @Override
            public Wiring wiring(Binder binder) {
                Module[] moduleArray = CONVERTERS;
                int n = CONVERTERS.length;
                int n2 = 0;
                while (n2 < n) {
                    Module m = moduleArray[n2];
                    m.configure(binder);
                    ++n2;
                }
                return new LocatorWiring(binder);
            }
        };

        public Wiring wiring(Binder var1);
    }
}

