/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.wagon.repository;

import java.io.Serializable;
import java.util.Properties;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.kotlin.org.apache.maven.wagon.PathUtils;
import org.jetbrains.kotlin.org.apache.maven.wagon.repository.RepositoryPermissions;

public class Repository
implements Serializable {
    private String id;
    private String name;
    private String host;
    private int port = -1;
    private String basedir;
    private String protocol;
    private String url;
    private RepositoryPermissions permissions;
    private Properties parameters = new Properties();
    private String username = null;
    private String password = null;

    public Repository() {
    }

    public Repository(String id, String url) {
        if (id == null) {
            throw new NullPointerException("id cannot be null");
        }
        this.setId(id);
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        this.setUrl(url);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getPort() {
        return this.port;
    }

    public void setUrl(String url) {
        String username;
        this.url = url;
        this.protocol = PathUtils.protocol(url);
        this.host = PathUtils.host(url);
        this.port = PathUtils.port(url);
        this.basedir = PathUtils.basedir(url);
        this.username = username = PathUtils.user(url);
        if (username != null) {
            String password = PathUtils.password(url);
            if (password != null) {
                this.password = password;
                username = username + ":" + password;
            }
            username = username + "@";
            int index = url.indexOf(username);
            this.url = url.substring(0, index) + url.substring(index + username.length());
        }
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.protocol);
        sb.append("://");
        if (this.isIPv6Address()) {
            sb.append("[").append(this.getHost()).append("]");
        } else {
            sb.append(this.getHost());
        }
        if (this.port != -1) {
            sb.append(":");
            sb.append(this.port);
        }
        sb.append(this.basedir);
        return sb.toString();
    }

    private boolean isIPv6Address() {
        return this.getHost().contains(":");
    }

    public String getHost() {
        if (this.host == null) {
            return "localhost";
        }
        return this.host;
    }

    public String getName() {
        if (this.name == null) {
            return this.getId();
        }
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Repository[");
        if (StringUtils.isNotEmpty(this.getName())) {
            sb.append(this.getName()).append("|");
        }
        sb.append(this.getUrl());
        sb.append("]");
        return sb.toString();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setPermissions(RepositoryPermissions permissions) {
        this.permissions = permissions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Repository other = (Repository)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

