/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Provider;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLoggerManager;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.LifecycleManager;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.inject.DefaultRankingFunction;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.inject.DeferredProvider;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.plexus.ClassRealmManager;
import org.eclipse.sisu.plexus.DefaultPlexusBeanLocator;
import org.eclipse.sisu.plexus.Hints;
import org.eclipse.sisu.plexus.PlexusAnnotatedBeanModule;
import org.eclipse.sisu.plexus.PlexusBean;
import org.eclipse.sisu.plexus.PlexusBeanConverter;
import org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.eclipse.sisu.plexus.PlexusBeanModule;
import org.eclipse.sisu.plexus.PlexusBindingModule;
import org.eclipse.sisu.plexus.PlexusDateTypeConverter;
import org.eclipse.sisu.plexus.PlexusLifecycleManager;
import org.eclipse.sisu.plexus.PlexusXmlBeanConverter;
import org.eclipse.sisu.plexus.PlexusXmlBeanModule;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.LoadedClass;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.wire.MergedModule;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.WireModule;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Guice;
import org.jetbrains.kotlin.com.google.inject.Injector;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.name.Names;
import org.jetbrains.kotlin.com.google.inject.util.Providers;
import org.slf4j.ILoggerFactory;

public final class DefaultPlexusContainer
implements MutablePlexusContainer {
    private static final Module[] NO_CUSTOM_MODULES;
    final AtomicInteger plexusRank = new AtomicInteger();
    final Map<ClassRealm, List<ComponentDescriptor<?>>> descriptorMap = new IdentityHashMap();
    final ThreadLocal<ClassRealm> lookupRealm = new ThreadLocal();
    final LoggerManagerProvider loggerManagerProvider = new LoggerManagerProvider();
    final MutableBeanLocator qualifiedBeanLocator = new DefaultBeanLocator();
    final Context context;
    final Map<?, ?> variables;
    final ClassRealm containerRealm;
    final ClassRealmManager classRealmManager;
    final PlexusBeanLocator plexusBeanLocator;
    final BeanManager plexusBeanManager;
    private final String componentVisibility;
    private final boolean isAutoWiringEnabled;
    private final BeanScanning scanning;
    private final Module containerModule = new ContainerModule();
    private final Module defaultsModule = new DefaultsModule();
    private LoggerManager loggerManager = new ConsoleLoggerManager();
    private Logger logger;
    private boolean disposing;

    static {
        System.setProperty("guice.disable.misplaced.annotation.check", "true");
        NO_CUSTOM_MODULES = new Module[0];
    }

    public DefaultPlexusContainer() throws PlexusContainerException {
        this(new DefaultContainerConfiguration());
    }

    public DefaultPlexusContainer(ContainerConfiguration configuration) throws PlexusContainerException {
        this(configuration, NO_CUSTOM_MODULES);
    }

    public DefaultPlexusContainer(ContainerConfiguration configuration, Module ... customModules) throws PlexusContainerException {
        URL plexusXml = this.lookupPlexusXml(configuration);
        this.context = DefaultPlexusContainer.getContextComponent(configuration);
        this.context.put("plexus", this);
        this.variables = new ContextMapAdapter(this.context);
        this.containerRealm = DefaultPlexusContainer.lookupContainerRealm(configuration);
        this.classRealmManager = new ClassRealmManager(this.qualifiedBeanLocator);
        this.containerRealm.getWorld().addListener(this.classRealmManager);
        this.componentVisibility = configuration.getComponentVisibility();
        this.isAutoWiringEnabled = configuration.getAutoWiring();
        this.scanning = DefaultPlexusContainer.parseScanningOption(configuration.getClassPathScanning());
        this.plexusBeanLocator = new DefaultPlexusBeanLocator(this.qualifiedBeanLocator, this.componentVisibility);
        LifecycleManager jsr250Lifecycle = configuration.getJSR250Lifecycle() ? new LifecycleManager() : null;
        this.plexusBeanManager = new PlexusLifecycleManager(Providers.of(this.context), this.loggerManagerProvider, new SLF4JLoggerFactoryProvider(), jsr250Lifecycle);
        this.setLookupRealm(this.containerRealm);
        ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
        URLClassSpace space = new URLClassSpace(this.containerRealm);
        beanModules.add(new PlexusXmlBeanModule(space, this.variables, plexusXml));
        BeanScanning global = BeanScanning.INDEX == this.scanning ? BeanScanning.GLOBAL_INDEX : this.scanning;
        beanModules.add(new PlexusAnnotatedBeanModule(space, this.variables, global));
        try {
            this.addPlexusInjector(beanModules, new BootModule(customModules));
        }
        catch (RuntimeException e) {
            try {
                this.dispose();
            }
            catch (Throwable throwable) {}
            throw e;
        }
    }

    @Override
    public <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return this.lookup(role, null, hint);
    }

    public <T> T lookup(Class<T> type, String role, String hint) throws ComponentLookupException {
        try {
            return (T)this.locate(role, type, hint).iterator().next().getValue();
        }
        catch (RuntimeException e) {
            throw new ComponentLookupException(e, type != null ? type.getName() : role, hint);
        }
    }

    public Injector addPlexusInjector(List<? extends PlexusBeanModule> beanModules, Module ... customModules) {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(this.containerModule);
        Collections.addAll(modules, customModules);
        modules.add(new PlexusBindingModule(this.plexusBeanManager, beanModules));
        modules.add(this.defaultsModule);
        return Guice.createInjector(this.isAutoWiringEnabled ? new WireModule(modules) : new MergedModule(modules));
    }

    public ClassWorld getClassWorld() {
        return this.containerRealm.getWorld();
    }

    @Override
    public ClassRealm getContainerRealm() {
        return this.containerRealm;
    }

    public ClassRealm setLookupRealm(ClassRealm realm) {
        ClassRealm oldRealm = this.lookupRealm.get();
        this.lookupRealm.set(realm);
        return oldRealm;
    }

    @Override
    public ClassRealm getLookupRealm() {
        return this.lookupRealm.get();
    }

    public synchronized LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    public synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = this.loggerManager.getLoggerForComponent(PlexusContainer.class.getName(), null);
        }
        return this.logger;
    }

    @Override
    public void release(Object component) {
        this.plexusBeanManager.unmanage(component);
    }

    public void dispose() {
        this.disposing = true;
        this.plexusBeanManager.unmanage();
        this.containerRealm.setParentRealm(null);
        this.qualifiedBeanLocator.clear();
        this.lookupRealm.remove();
        this.containerRealm.getWorld().removeListener(this.classRealmManager);
    }

    private static BeanScanning parseScanningOption(String scanning) {
        BeanScanning[] beanScanningArray = BeanScanning.values();
        int n = beanScanningArray.length;
        int n2 = 0;
        while (n2 < n) {
            BeanScanning option = beanScanningArray[n2];
            if (option.name().equalsIgnoreCase(scanning)) {
                return option;
            }
            ++n2;
        }
        return BeanScanning.OFF;
    }

    private static ClassRealm lookupContainerRealm(ContainerConfiguration configuration) throws PlexusContainerException {
        ClassRealm realm;
        block5: {
            realm = configuration.getRealm();
            if (realm == null) {
                ClassWorld world = configuration.getClassWorld();
                if (world == null) {
                    world = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
                }
                try {
                    realm = world.getRealm("plexus.core");
                }
                catch (NoSuchRealmException noSuchRealmException) {
                    Iterator<ClassRealm> realmIterator = world.getRealms().iterator();
                    if (!realmIterator.hasNext()) break block5;
                    realm = realmIterator.next();
                }
            }
        }
        if (realm == null) {
            throw new PlexusContainerException("Missing container class realm: plexus.core");
        }
        return realm;
    }

    private URL lookupPlexusXml(ContainerConfiguration configuration) {
        String configurationPath;
        URL url = configuration.getContainerConfigurationURL();
        if (url == null && (configurationPath = configuration.getContainerConfiguration()) != null) {
            File file;
            int index = 0;
            while (index < configurationPath.length() && configurationPath.charAt(index) == '/') {
                ++index;
            }
            url = this.getClass().getClassLoader().getResource(configurationPath.substring(index));
            if (url == null && (file = new File(configurationPath)).isFile()) {
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (url == null) {
                this.getLogger().debug("Missing container configuration: " + configurationPath);
            }
        }
        return url;
    }

    private static Context getContextComponent(ContainerConfiguration configuration) {
        Map<Object, Object> contextData = configuration.getContext();
        Context contextComponent = configuration.getContextComponent();
        if (contextComponent == null) {
            return new DefaultContext(contextData);
        }
        if (contextData != null) {
            for (Map.Entry<Object, Object> entry : contextData.entrySet()) {
                contextComponent.put(entry.getKey(), entry.getValue());
            }
        }
        return contextComponent;
    }

    private <T> Iterable<PlexusBean<T>> locate(String role, Class<T> type, String ... hints) {
        if (this.disposing) {
            return Collections.EMPTY_SET;
        }
        String[] canonicalHints = Hints.canonicalHints(hints);
        if (role == null || type != null && type.getName().equals(role)) {
            return this.plexusBeanLocator.locate(TypeLiteral.get(type), canonicalHints);
        }
        HashSet candidates = new HashSet();
        for (ClassRealm realm : this.getVisibleRealms()) {
            try {
                Iterable<PlexusBean<T>> beans;
                Class<?> clazz = realm.loadClass(role);
                if (!candidates.add(clazz) || !DefaultPlexusContainer.hasPlexusBeans(beans = this.plexusBeanLocator.locate(TypeLiteral.get(clazz), canonicalHints))) continue;
                return beans;
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {}
        }
        return Collections.EMPTY_SET;
    }

    private Collection<ClassRealm> getVisibleRealms() {
        Set<String> realmNames;
        ClassRealm threadContextRealm;
        Object[] realms = this.getClassWorld().getRealms().toArray();
        LinkedHashSet<ClassRealm> visibleRealms = new LinkedHashSet<ClassRealm>(realms.length);
        ClassRealm currentLookupRealm = this.getLookupRealm();
        if (currentLookupRealm != null) {
            visibleRealms.add(currentLookupRealm);
        }
        if ((threadContextRealm = ClassRealmManager.contextRealm()) != null) {
            visibleRealms.add(threadContextRealm);
        }
        if ("realm".equalsIgnoreCase(this.componentVisibility) && (realmNames = ClassRealmManager.visibleRealmNames(threadContextRealm)) != null && realmNames.size() > 0) {
            int i = realms.length - 1;
            while (i >= 0) {
                ClassRealm r = (ClassRealm)realms[i];
                if (realmNames.contains(r.toString())) {
                    visibleRealms.add(r);
                }
                --i;
            }
            return visibleRealms;
        }
        int i = realms.length - 1;
        while (i >= 0) {
            visibleRealms.add((ClassRealm)realms[i]);
            --i;
        }
        return visibleRealms;
    }

    private static <T> boolean hasPlexusBeans(Iterable<PlexusBean<T>> beans) {
        Iterator<PlexusBean<T>> i = beans.iterator();
        return i.hasNext() && i.next().getImplementationClass() != null;
    }

    final class BootModule
    implements Module {
        private final Module[] customBootModules;

        BootModule(Module[] customBootModules) {
            this.customBootModules = customBootModules;
        }

        @Override
        public void configure(Binder binder) {
            binder.requestInjection(DefaultPlexusContainer.this);
            Module[] moduleArray = this.customBootModules;
            int n = this.customBootModules.length;
            int n2 = 0;
            while (n2 < n) {
                Module m = moduleArray[n2];
                binder.install(m);
                ++n2;
            }
        }
    }

    final class ContainerModule
    implements Module {
        ContainerModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.bind(Context.class).toInstance(DefaultPlexusContainer.this.context);
            binder.bind(ParameterKeys.PROPERTIES).toInstance(DefaultPlexusContainer.this.context.getContextData());
            binder.bind(MutableBeanLocator.class).toInstance(DefaultPlexusContainer.this.qualifiedBeanLocator);
            binder.bind(PlexusBeanLocator.class).toInstance(DefaultPlexusContainer.this.plexusBeanLocator);
            binder.bind(BeanManager.class).toInstance(DefaultPlexusContainer.this.plexusBeanManager);
            binder.bind(PlexusContainer.class).to(MutablePlexusContainer.class);
            binder.bind(MutablePlexusContainer.class).to(DefaultPlexusContainer.class);
            binder.bind(DefaultPlexusContainer.class).toProvider(Providers.of(DefaultPlexusContainer.this));
        }
    }

    final class DefaultsModule
    implements Module {
        private final LoggerProvider loggerProvider;
        private final PlexusDateTypeConverter dateConverter;

        DefaultsModule() {
            this.loggerProvider = new LoggerProvider();
            this.dateConverter = new PlexusDateTypeConverter();
        }

        @Override
        public void configure(Binder binder) {
            binder.bind(LoggerManager.class).toProvider(DefaultPlexusContainer.this.loggerManagerProvider);
            binder.bind(Logger.class).toProvider(this.loggerProvider);
            Key<RankingFunction> plexusRankingKey = Key.get(RankingFunction.class, (Annotation)Names.named("plexus"));
            binder.bind(plexusRankingKey).toInstance(new DefaultRankingFunction(DefaultPlexusContainer.this.plexusRank.incrementAndGet()));
            binder.bind(RankingFunction.class).to(plexusRankingKey);
            binder.install(this.dateConverter);
            binder.bind(PlexusBeanConverter.class).to(PlexusXmlBeanConverter.class);
        }
    }

    final class LoggerManagerProvider
    implements DeferredProvider<LoggerManager> {
        LoggerManagerProvider() {
        }

        @Override
        public LoggerManager get() {
            return DefaultPlexusContainer.this.getLoggerManager();
        }

        @Override
        public DeferredClass<LoggerManager> getImplementationClass() {
            return new LoadedClass<LoggerManager>(this.get().getClass());
        }
    }

    final class LoggerProvider
    implements DeferredProvider<Logger> {
        LoggerProvider() {
        }

        @Override
        public Logger get() {
            return DefaultPlexusContainer.this.getLogger();
        }

        @Override
        public DeferredClass<Logger> getImplementationClass() {
            return new LoadedClass<Logger>(this.get().getClass());
        }
    }

    final class SLF4JLoggerFactoryProvider
    implements Provider<Object> {
        SLF4JLoggerFactoryProvider() {
        }

        @Override
        public Object get() {
            return DefaultPlexusContainer.this.plexusBeanLocator.locate(TypeLiteral.get(ILoggerFactory.class), new String[0]).iterator().next().getValue();
        }
    }
}

