/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;

public final class CollectRequest {
    private Artifact rootArtifact;
    private Dependency root;
    private List<Dependency> dependencies = Collections.emptyList();
    private List<Dependency> managedDependencies = Collections.emptyList();
    private List<RemoteRepository> repositories = Collections.emptyList();
    private String context = "";
    private RequestTrace trace;

    public Artifact getRootArtifact() {
        return this.rootArtifact;
    }

    public Dependency getRoot() {
        return this.root;
    }

    public CollectRequest setRoot(Dependency root) {
        this.root = root;
        return this;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDependencies;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public CollectRequest addRepository(RemoteRepository repository) {
        if (repository != null) {
            if (this.repositories.isEmpty()) {
                this.repositories = new ArrayList<RemoteRepository>();
            }
            this.repositories.add(repository);
        }
        return this;
    }

    public String getRequestContext() {
        return this.context;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public CollectRequest setTrace(RequestTrace trace) {
        this.trace = trace;
        return this;
    }

    public String toString() {
        return this.getRoot() + " -> " + this.getDependencies() + " < " + this.getRepositories();
    }
}

