/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.NoTransporterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class DefaultTransporterProvider
implements TransporterProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransporterProvider.class);
    private Collection<TransporterFactory> factories = new ArrayList<TransporterFactory>();

    @Override
    public void initService(ServiceLocator locator) {
        this.setTransporterFactories(locator.getServices(TransporterFactory.class));
    }

    public DefaultTransporterProvider setTransporterFactories(Collection<TransporterFactory> factories) {
        this.factories = factories == null ? new ArrayList<TransporterFactory>() : factories;
        return this;
    }

    @Override
    public Transporter newTransporter(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(repository, "remote repository cannot be null");
        PrioritizedComponents<TransporterFactory> factories = new PrioritizedComponents<TransporterFactory>(session);
        for (TransporterFactory transporterFactory : this.factories) {
            factories.add(transporterFactory, transporterFactory.getPriority());
        }
        ArrayList<NoTransporterException> errors = new ArrayList<NoTransporterException>();
        for (PrioritizedComponent prioritizedComponent : factories.getEnabled()) {
            try {
                Transporter transporter = ((TransporterFactory)prioritizedComponent.getComponent()).newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using transporter ").append(transporter.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, transporter);
                    buffer.append(" with priority ").append(prioritizedComponent.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    LOGGER.debug(buffer.toString());
                }
                return transporter;
            }
            catch (NoTransporterException e) {
                errors.add(e);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            for (Exception exception : errors) {
                LOGGER.debug("Could not obtain transporter factory for {}", (Object)repository, (Object)exception);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (factories.isEmpty()) {
            stringBuilder.append("No transporter factories registered");
        } else {
            stringBuilder.append("Cannot access ").append(repository.getUrl());
            stringBuilder.append(" using the registered transporter factories: ");
            factories.list(stringBuilder);
        }
        throw new NoTransporterException(repository, stringBuilder.toString(), errors.size() == 1 ? (NoTransporterException)errors.get(0) : null);
    }
}

