/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.sisu.inject.BeanCache;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.BindingSubscriber;
import org.eclipse.sisu.inject.RankedSequence;
import org.eclipse.sisu.inject.Weak;
import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;

final class RankedBindings<T>
implements Iterable<Binding<T>>,
BindingSubscriber<T> {
    final transient RankedSequence<Binding<T>> bindings = new RankedSequence();
    final transient TypeLiteral<T> type;
    final transient RankedSequence<BindingPublisher> pendingPublishers;
    final Collection<BeanCache<?, T>> cachedBeans = Weak.elements();

    RankedBindings(TypeLiteral<T> type, RankedSequence<BindingPublisher> publishers) {
        this.type = type;
        this.pendingPublishers = new RankedSequence<BindingPublisher>(publishers);
    }

    @Override
    public TypeLiteral<T> type() {
        return this.type;
    }

    @Override
    public void add(Binding<T> binding, int rank) {
        this.bindings.insert(binding, rank);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Binding<T> binding) {
        if (this.bindings.removeThis(binding)) {
            Collection<BeanCache<?, T>> collection = this.cachedBeans;
            synchronized (collection) {
                for (BeanCache<?, T> beans : this.cachedBeans) {
                    beans.remove(binding);
                }
            }
        }
    }

    @Override
    public Iterable<Binding<T>> bindings() {
        return this.bindings.snapshot();
    }

    public Itr iterator() {
        return new Itr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <Q extends Annotation> BeanCache<Q, T> newBeanCache() {
        BeanCache beans = new BeanCache();
        Collection<BeanCache<?, T>> collection = this.cachedBeans;
        synchronized (collection) {
            this.cachedBeans.add(beans);
        }
        return beans;
    }

    void add(BindingPublisher publisher, int rank) {
        this.pendingPublishers.insert(publisher, rank);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(BindingPublisher publisher) {
        BindingPublisher bindingPublisher = publisher;
        synchronized (bindingPublisher) {
            if (!this.pendingPublishers.removeThis(publisher)) {
                publisher.unsubscribe(this);
            }
        }
    }

    final class Itr
    implements Iterator<Binding<T>> {
        private final RankedSequence.Itr itr;

        Itr() {
            this.itr = RankedBindings.this.bindings.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            BindingPublisher publisher = RankedBindings.this.pendingPublishers.peek();
            while (publisher != null && !this.itr.hasNext(publisher.maxBindingRank())) {
                BindingPublisher bindingPublisher = publisher;
                synchronized (bindingPublisher) {
                    if (publisher == RankedBindings.this.pendingPublishers.peek()) {
                        publisher.subscribe(RankedBindings.this);
                        RankedBindings.this.pendingPublishers.removeThis(publisher);
                    }
                }
                publisher = RankedBindings.this.pendingPublishers.peek();
            }
            return this.itr.hasNext();
        }

        @Override
        public Binding<T> next() {
            return (Binding)this.itr.next();
        }

        public int rank() {
            return this.itr.rank();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

