/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.client.methods;

import java.util.concurrent.atomic.AtomicMarkableReference;
import org.jetbrains.kotlin.org.apache.http.HttpRequest;
import org.jetbrains.kotlin.org.apache.http.client.methods.HttpExecutionAware;
import org.jetbrains.kotlin.org.apache.http.client.utils.CloneUtils;
import org.jetbrains.kotlin.org.apache.http.concurrent.Cancellable;
import org.jetbrains.kotlin.org.apache.http.message.AbstractHttpMessage;

public abstract class AbstractExecutionAwareRequest
extends AbstractHttpMessage
implements Cloneable,
HttpRequest,
HttpExecutionAware {
    private final AtomicMarkableReference<Cancellable> cancellableRef = new AtomicMarkableReference<Object>(null, false);

    protected AbstractExecutionAwareRequest() {
    }

    @Override
    public boolean isAborted() {
        return this.cancellableRef.isMarked();
    }

    @Override
    public void setCancellable(Cancellable cancellable) {
        Cancellable actualCancellable = this.cancellableRef.getReference();
        if (!this.cancellableRef.compareAndSet(actualCancellable, cancellable, false, false)) {
            cancellable.cancel();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractExecutionAwareRequest clone = (AbstractExecutionAwareRequest)super.clone();
        clone.headergroup = CloneUtils.cloneObject(this.headergroup);
        clone.params = CloneUtils.cloneObject(this.params);
        return clone;
    }
}

