/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal.aop;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.kotlin.com.google.inject.internal.aop.ClassDefiner;

final class AnonymousClassDefiner
implements ClassDefiner {
    private static final Object THE_UNSAFE;
    private static final Method ANONYMOUS_DEFINE_METHOD;

    AnonymousClassDefiner() {
    }

    @Override
    public Class<?> define(Class<?> hostClass, byte[] bytecode) throws Exception {
        return (Class)ANONYMOUS_DEFINE_METHOD.invoke(THE_UNSAFE, hostClass, bytecode, null);
    }

    static {
        try {
            Class<?> unsafeType = Class.forName("sun.misc.Unsafe");
            Field theUnsafeField = unsafeType.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            THE_UNSAFE = theUnsafeField.get(null);
            ANONYMOUS_DEFINE_METHOD = unsafeType.getMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

