/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.function.Predicate;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.ClassWorld;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.ClassRealm;

public class FilteredClassRealm
extends ClassRealm {
    private final Predicate<String> filter;

    public FilteredClassRealm(Predicate<String> filter, ClassWorld world, String id, ClassLoader baseClassLoader) {
        super(world, id, baseClassLoader);
        this.filter = filter;
    }

    @Override
    protected Class<?> findClassInternal(String name) throws ClassNotFoundException {
        String resourceName = name.replace('.', '/').concat(".class");
        if (!this.filter.test(resourceName)) {
            throw new ClassNotFoundException(name);
        }
        return super.findClassInternal(name);
    }

    @Override
    public URL findResource(String name) {
        if (!this.filter.test(name)) {
            return null;
        }
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (!this.filter.test(name)) {
            return Collections.emptyEnumeration();
        }
        return super.findResources(name);
    }
}

