/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.wire;

import java.util.Arrays;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Injector;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.spi.Element;
import org.jetbrains.kotlin.com.google.inject.spi.Elements;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DefaultBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.ElementAnalyzer;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.WireModule;

public final class ChildWireModule
implements Module {
    private final Injector parent;
    private final Iterable<Module> modules;
    private WireModule.Strategy strategy = WireModule.Strategy.DEFAULT;

    public ChildWireModule(Injector parent, Module ... modules) {
        this(parent, Arrays.asList(modules));
    }

    public ChildWireModule(Injector parent, Iterable<Module> modules) {
        this.modules = modules;
        this.parent = parent;
    }

    public Module with(WireModule.Strategy _strategy) {
        this.strategy = _strategy;
        return this;
    }

    @Override
    public void configure(Binder binder) {
        binder.requestStaticInjection(DefaultBeanLocator.class);
        ElementAnalyzer analyzer = new ElementAnalyzer(binder);
        for (Injector i = this.parent; i != null; i = i.getParent()) {
            analyzer.ignoreKeys(i.getAllBindings().keySet());
        }
        for (Element e : Elements.getElements(this.modules)) {
            e.acceptVisitor(analyzer);
        }
        analyzer.apply(this.strategy);
    }
}

