/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.AbstractBasicConverter;

public class TemporalConverter
extends AbstractBasicConverter {
    private static final DateTimeFormatter PLEXUS_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[[a][.S [a]]", Locale.US).withZone(ZoneId.systemDefault());

    @Override
    public boolean canConvert(Class<?> type) {
        return Temporal.class.isAssignableFrom(type);
    }

    @Override
    protected final Object fromString(String str, Class<?> type) throws ComponentConfigurationException {
        return this.createTemporalFromString(str, type);
    }

    private Temporal createTemporalFromString(String value, Class<?> type) {
        Comparable<ChronoLocalDate> temporal;
        TemporalAccessor temporalAccessor;
        try {
            temporalAccessor = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(value);
        }
        catch (DateTimeParseException e) {
            temporalAccessor = PLEXUS_DATE_TIME_FORMATTER.parse(value);
        }
        if (type.equals(LocalDate.class)) {
            temporal = LocalDate.from(temporalAccessor);
        } else if (type.equals(LocalDateTime.class)) {
            temporal = LocalDateTime.from(temporalAccessor);
        } else if (type.equals(LocalTime.class)) {
            temporal = LocalTime.from(temporalAccessor);
        } else if (type.equals(Instant.class)) {
            temporal = Instant.from(temporalAccessor);
        } else if (type.equals(OffsetDateTime.class)) {
            temporal = ZonedDateTime.from(temporalAccessor).toOffsetDateTime();
        } else if (type.equals(OffsetTime.class)) {
            temporal = ZonedDateTime.from(temporalAccessor).toOffsetDateTime().toOffsetTime();
        } else if (type.equals(ZonedDateTime.class)) {
            temporal = ZonedDateTime.from(temporalAccessor);
        } else {
            throw new IllegalArgumentException("Unsupported temporal type " + type);
        }
        return temporal;
    }
}

