/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.host;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ExternalSourceCode;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptSourceNamedFragment;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.FileScriptSource;
import kotlin.script.experimental.host.StringScriptSource;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0002\u001a\n\u0010\f\u001a\u00020\u0003*\u00020\r\u001a\u0016\u0010\f\u001a\u00020\u0003*\u00020\u00012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0001\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\rH\u0002\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\u0015H\u0002\"\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"getMergedScriptText", "", "script", "Lkotlin/script/experimental/api/SourceCode;", "configuration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "cleanContentPreservingLinesLayout", "", "", "start", "", "end", "toScriptSource", "Ljava/io/File;", "name", "textSafe", "Lkotlin/script/experimental/api/ExternalSourceCode;", "getTextSafe", "(Lkotlin/script/experimental/api/ExternalSourceCode;)Ljava/lang/String;", "UTF8_BOM", "readTextSkipUtf8Bom", "Ljava/net/URL;", "kotlin-scripting-common"})
@SourceDebugExtension(value={"SMAP\nscriptHostUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 scriptHostUtil.kt\nkotlin/script/experimental/host/ScriptHostUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,143:1\n1914#2,2:144\n1914#2,2:146\n989#3:148\n1064#3,3:149\n*S KotlinDebug\n*F\n+ 1 scriptHostUtil.kt\nkotlin/script/experimental/host/ScriptHostUtilKt\n*L\n32#1:144,2\n41#1:146,2\n54#1:148\n54#1:149,3\n*E\n"})
public final class ScriptHostUtilKt {
    @NotNull
    private static final String UTF8_BOM = "\ufeff";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getMergedScriptText(@NotNull SourceCode script, @Nullable ScriptCompilationConfiguration configuration) {
        String string;
        List<ScriptSourceNamedFragment> sourceFragments;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String originalScriptText = script.getText();
        ScriptCompilationConfiguration scriptCompilationConfiguration = configuration;
        List<ScriptSourceNamedFragment> list = sourceFragments = scriptCompilationConfiguration != null ? scriptCompilationConfiguration.get(ScriptCompilationKt.getSourceFragments(ScriptCompilationConfiguration.Companion)) : null;
        if (sourceFragments == null || sourceFragments.isEmpty()) {
            string = originalScriptText;
        } else {
            Integer positionOfLastAppended;
            StringBuilder sb = new StringBuilder(originalScriptText.length());
            ScriptSourceNamedFragment prevFragment = null;
            for (ScriptSourceNamedFragment scriptSourceNamedFragment : sourceFragments) {
                int curPos;
                int n;
                Integer fragmentStartPos = scriptSourceNamedFragment.getRange().getStart().getAbsolutePos();
                Integer fragmentEndPos = scriptSourceNamedFragment.getRange().getEnd().getAbsolutePos();
                if (fragmentStartPos == null || fragmentEndPos == null) {
                    throw new RuntimeException("Script fragments require absolute positions (received: " + scriptSourceNamedFragment + ')');
                }
                ScriptSourceNamedFragment scriptSourceNamedFragment2 = prevFragment;
                if (scriptSourceNamedFragment2 == null) {
                    n = 0;
                } else {
                    Integer n2 = scriptSourceNamedFragment2.getRange().getEnd().getAbsolutePos();
                    Intrinsics.checkNotNull((Object)n2);
                    n = curPos = n2.intValue();
                }
                if (prevFragment != null) {
                    Integer n3 = prevFragment.getRange().getEnd().getAbsolutePos();
                    Intrinsics.checkNotNull((Object)n3);
                    if (n3 > fragmentStartPos) {
                        throw new RuntimeException("Unsorted or overlapping fragments: previous: " + prevFragment + ", current: " + scriptSourceNamedFragment);
                    }
                }
                if (curPos < fragmentStartPos) {
                    void $this$forEach$iv;
                    Iterable iterable = ScriptHostUtilKt.cleanContentPreservingLinesLayout(originalScriptText, curPos, fragmentStartPos);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        char p0 = ((Character)element$iv).charValue();
                        boolean bl = false;
                        sb.append(p0);
                    }
                }
                sb.append(originalScriptText.subSequence(fragmentStartPos, fragmentEndPos));
                prevFragment = scriptSourceNamedFragment;
            }
            Serializable serializable = prevFragment;
            Integer n = serializable != null && (serializable = ((ScriptSourceNamedFragment)serializable).getRange()) != null && (serializable = ((SourceCode.Range)serializable).getEnd()) != null ? ((SourceCode.Position)serializable).getAbsolutePos() : (positionOfLastAppended = null);
            if (positionOfLastAppended != null && positionOfLastAppended < originalScriptText.length()) {
                Iterable iterable = ScriptHostUtilKt.cleanContentPreservingLinesLayout$default(originalScriptText, positionOfLastAppended, 0, 2, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : iterable) {
                    char p0 = ((Character)element$iv).charValue();
                    boolean bl = false;
                    sb.append(p0);
                }
            }
            String string2 = sb.toString();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Character> cleanContentPreservingLinesLayout(String $this$cleanContentPreservingLinesLayout, int start, int end) {
        void $this$mapTo$iv$iv;
        CharSequence $this$map$iv = $this$cleanContentPreservingLinesLayout.subSequence(start, end);
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            char c;
            void it;
            char item$iv$iv;
            char c2 = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (it) {
                case 10: 
                case 13: {
                    c = it;
                    break;
                }
                default: {
                    c = ' ';
                }
            }
            collection.add(Character.valueOf(c));
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List cleanContentPreservingLinesLayout$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return ScriptHostUtilKt.cleanContentPreservingLinesLayout(string, n, n2);
    }

    @NotNull
    public static final SourceCode toScriptSource(@NotNull File $this$toScriptSource) {
        Intrinsics.checkNotNullParameter((Object)$this$toScriptSource, (String)"<this>");
        return new FileScriptSource($this$toScriptSource, null, 2, null);
    }

    @NotNull
    public static final SourceCode toScriptSource(@NotNull String $this$toScriptSource, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)$this$toScriptSource, (String)"<this>");
        return new StringScriptSource($this$toScriptSource, name);
    }

    public static /* synthetic */ SourceCode toScriptSource$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return ScriptHostUtilKt.toScriptSource(string, string2);
    }

    private static final String getTextSafe(ExternalSourceCode $this$textSafe) {
        String string;
        try {
            string = $this$textSafe.getText();
        }
        catch (Throwable e) {
            string = null;
        }
        return string;
    }

    private static final String readTextSkipUtf8Bom(File $this$readTextSkipUtf8Bom) {
        return StringsKt.removePrefix((String)FilesKt.readText$default((File)$this$readTextSkipUtf8Bom, null, (int)1, null), (CharSequence)UTF8_BOM);
    }

    private static final String readTextSkipUtf8Bom(URL $this$readTextSkipUtf8Bom) {
        URL uRL = $this$readTextSkipUtf8Bom;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        return StringsKt.removePrefix((String)new String(byArray, charset), (CharSequence)UTF8_BOM);
    }

    public static final /* synthetic */ String access$getTextSafe(ExternalSourceCode $receiver) {
        return ScriptHostUtilKt.getTextSafe($receiver);
    }

    public static final /* synthetic */ String access$readTextSkipUtf8Bom(File $receiver) {
        return ScriptHostUtilKt.readTextSkipUtf8Bom($receiver);
    }

    public static final /* synthetic */ String access$readTextSkipUtf8Bom(URL $receiver) {
        return ScriptHostUtilKt.readTextSkipUtf8Bom($receiver);
    }
}

