/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.noarg.diagnostic;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.extensions.AnnotationBasedExtension;
import org.jetbrains.kotlin.noarg.diagnostic.ErrorsNoArg;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/noarg/diagnostic/AbstractNoArgDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "Lorg/jetbrains/kotlin/extensions/AnnotationBasedExtension;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isNoArgConstructor", "", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "kotlin-maven-noarg"})
public abstract class AbstractNoArgDeclarationChecker
implements DeclarationChecker,
AnnotationBasedExtension {
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        boolean bl;
        ClassDescriptor superClass;
        block9: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(descriptor instanceof ClassDescriptor) || !(declaration instanceof KtClass)) {
                return;
            }
            if (((ClassDescriptor)descriptor).getKind() != ClassKind.CLASS) {
                return;
            }
            if (!this.hasSpecialAnnotation(descriptor, (KtModifierListOwner)declaration)) {
                return;
            }
            superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)((ClassDescriptor)descriptor));
            Collection collection = superClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"superClass.constructors");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv;
                    boolean bl2 = false;
                    ClassConstructorDescriptor classConstructorDescriptor = it;
                    Intrinsics.checkNotNullExpressionValue((Object)classConstructorDescriptor, (String)"it");
                    if (!this.isNoArgConstructor((ConstructorDescriptor)classConstructorDescriptor)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl && !this.hasSpecialAnnotation((DeclarationDescriptor)superClass, (KtModifierListOwner)declaration)) {
            PsiElement psiElement;
            PsiElement psiElement2 = ((KtClass)declaration).getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = psiElement = ((KtClass)declaration).getClassOrInterfaceKeyword();
            }
            if (psiElement2 == null) {
                psiElement = (PsiElement)declaration;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"declaration.nameIdentifi\u2026eKeyword() ?: declaration");
            PsiElement reportTarget = psiElement;
            context.getTrace().report((Diagnostic)ErrorsNoArg.NO_NOARG_CONSTRUCTOR_IN_SUPERCLASS.on(reportTarget));
        }
    }

    private final boolean isNoArgConstructor(ConstructorDescriptor $this$isNoArgConstructor) {
        boolean bl;
        block3: {
            List list = $this$isNoArgConstructor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"valueParameters");
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueParameterDescriptor p1 = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    if (p1.declaresDefaultValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean hasSpecialAnnotation(@NotNull DeclarationDescriptor $this$hasSpecialAnnotation, @Nullable KtModifierListOwner modifierListOwner) {
        Intrinsics.checkNotNullParameter((Object)$this$hasSpecialAnnotation, (String)"$this$hasSpecialAnnotation");
        return AnnotationBasedExtension.DefaultImpls.hasSpecialAnnotation((AnnotationBasedExtension)this, (DeclarationDescriptor)$this$hasSpecialAnnotation, (KtModifierListOwner)modifierListOwner);
    }
}

