/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.noarg.fir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.noarg.fir.FirNoArgPredicateMatcher;
import org.jetbrains.kotlin.noarg.fir.KtErrorsNoArg;
import org.jetbrains.kotlin.noarg.fir.NoArgAnnotationNameProviderKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/noarg/fir/FirNoArgDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getSuperClassSymbolOrAny", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isNoArgConstructor", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "kotlin-maven-noarg"})
@SourceDebugExtension(value={"SMAP\nFirNoArgDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNoArgDeclarationChecker.kt\norg/jetbrains/kotlin/noarg/fir/FirNoArgDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n35#2:58\n50#2:59\n800#3,11:60\n2620#3,3:71\n1722#3,3:74\n*S KotlinDebug\n*F\n+ 1 FirNoArgDeclarationChecker.kt\norg/jetbrains/kotlin/noarg/fir/FirNoArgDeclarationChecker\n*L\n34#1:58\n35#1:59\n39#1:60,11\n39#1:71,3\n54#1:74,3\n*E\n"})
public final class FirNoArgDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirNoArgDeclarationChecker INSTANCE = new FirNoArgDeclarationChecker();

    private FirNoArgDeclarationChecker() {
    }

    /*
     * WARNING - void declaration
     */
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        FirRegularClassSymbol superClassSymbol;
        FirNoArgPredicateMatcher matcher;
        KtSourceElement source;
        block11: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            KtSourceElement ktSourceElement = declaration.getSource();
            if (ktSourceElement == null) {
                return;
            }
            source = ktSourceElement;
            if (declaration.getClassKind() != ClassKind.CLASS) {
                return;
            }
            matcher = NoArgAnnotationNameProviderKt.getNoArgPredicateMatcher(context.getSession());
            if (!matcher.isAnnotated(declaration.getSymbol())) {
                return;
            }
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isInner = false;
            if ($this$isInner$iv.getStatus().isInner()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsNoArg.INSTANCE.getNOARG_ON_INNER_CLASS_ERROR(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            } else {
                FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)declaration;
                boolean $i$f$isLocal = false;
                if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsNoArg.INSTANCE.getNOARG_ON_LOCAL_CLASS_ERROR(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                }
            }
            superClassSymbol = this.getSuperClassSymbolOrAny(declaration.getSymbol(), context.getSession());
            Iterable $this$filterIsInstance$iv = superClassSymbol.getDeclarationSymbols();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirConstructorSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$none$iv = (List)destination$iv$iv;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FirConstructorSymbol it = (FirConstructorSymbol)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.isNoArgConstructor(it)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl && !matcher.isAnnotated(superClassSymbol)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsNoArg.INSTANCE.getNO_NOARG_CONSTRUCTOR_IN_SUPERCLASS(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
    }

    private final FirRegularClassSymbol getSuperClassSymbolOrAny(FirRegularClassSymbol $this$getSuperClassSymbolOrAny, FirSession session) {
        for (ConeKotlinType superType : $this$getSuperClassSymbolOrAny.getResolvedSuperTypes()) {
            FirRegularClassSymbol symbol;
            if (TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)superType, (FirSession)session), (FirSession)session) == null || symbol.getClassKind() != ClassKind.CLASS) continue;
            return symbol;
        }
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol((ConeClassLikeType)session.getBuiltinTypes().getAnyType().getType(), (FirSession)session);
        if (firRegularClassSymbol == null) {
            throw new IllegalStateException("Symbol for Any not found".toString());
        }
        return firRegularClassSymbol;
    }

    private final boolean isNoArgConstructor(FirConstructorSymbol $this$isNoArgConstructor) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = $this$isNoArgConstructor.getValueParameterSymbols();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl2 = false;
                    if (it.getHasDefaultValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

