/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.maven.MavenPluginLogMessageCollector;

public abstract class KotlinCompileMojoBase<A extends CommonCompilerArguments>
extends AbstractMojo {
    @Parameter(defaultValue="${project.compileSourceRoots}", required=true)
    private List<String> defaultSourceDirs;
    @Parameter
    private List<String> sourceDirs;
    @Parameter(defaultValue="false")
    public boolean nowarn;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    public String output;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
    public String testOutput;
    @Parameter
    public String module;
    @Parameter
    public String testModule;
    @Parameter
    public List<String> args;

    protected List<String> getSourceFilePaths() {
        if (this.sourceDirs != null && !this.sourceDirs.isEmpty()) {
            return this.sourceDirs;
        }
        return this.defaultSourceDirs;
    }

    public List<File> getSourceDirs() {
        List<String> sources = this.getSourceFilePaths();
        ArrayList<File> result = new ArrayList<File>(sources.size());
        File baseDir = this.project.getBasedir();
        for (String source : sources) {
            File f = new File(source);
            if (f.isAbsolute()) {
                result.add(f);
                continue;
            }
            result.add(new File(baseDir, source));
        }
        return result;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Kotlin Compiler version 1.0.3");
        if (!this.hasKotlinFilesInSources()) {
            this.getLog().warn((CharSequence)"No sources found skipping Kotlin compile");
            return;
        }
        A arguments = this.createCompilerArguments();
        CLICompiler<A> compiler = this.createCompiler();
        this.configureCompilerArguments(arguments, compiler);
        this.printCompilerArgumentsIfDebugEnabled(arguments, compiler);
        MavenPluginLogMessageCollector messageCollector = new MavenPluginLogMessageCollector(this.getLog());
        ExitCode exitCode = compiler.exec((MessageCollector)messageCollector, Services.EMPTY, arguments);
        switch (exitCode) {
            case COMPILATION_ERROR: {
                throw new MojoExecutionException("Compilation error. See log for more details");
            }
            case INTERNAL_ERROR: {
                throw new MojoExecutionException("Internal compiler error. See log for more details");
            }
        }
    }

    private boolean hasKotlinFilesInSources() throws MojoExecutionException {
        List<File> sources = this.getSourceDirs();
        if (sources == null || sources.isEmpty()) {
            return false;
        }
        for (File root : sources) {
            boolean sourcesExists;
            if (!root.exists() || !(sourcesExists = !FileUtil.processFilesRecursively((File)root, (Processor)new Processor<File>(){

                public boolean process(File file) {
                    return !file.getName().endsWith(".kt");
                }
            }))) continue;
            return true;
        }
        return false;
    }

    private void printCompilerArgumentsIfDebugEnabled(@NotNull A arguments, @NotNull CLICompiler<A> compiler) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Invoking compiler " + compiler + " with arguments:"));
            try {
                Field[] fields;
                for (Field f : fields = arguments.getClass().getFields()) {
                    Object value = f.get(arguments);
                    String valueString = value instanceof Object[] ? Arrays.deepToString((Object[])value) : (value != null ? String.valueOf(value) : "(null)");
                    this.getLog().debug((CharSequence)(f.getName() + "=" + valueString));
                }
                this.getLog().debug((CharSequence)"End of arguments");
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Failed to print compiler arguments: " + e), (Throwable)e);
            }
        }
    }

    @NotNull
    protected abstract CLICompiler<A> createCompiler();

    @NotNull
    protected abstract A createCompilerArguments();

    protected abstract void configureSpecificCompilerArguments(@NotNull A var1) throws MojoExecutionException;

    private void configureCompilerArguments(@NotNull A arguments, @NotNull CLICompiler<A> compiler) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            ((CommonCompilerArguments)arguments).verbose = true;
        }
        ArrayList<String> sources = new ArrayList<String>();
        for (File source : this.getSourceDirs()) {
            if (source.exists()) {
                sources.add(source.getPath());
                continue;
            }
            this.getLog().warn((CharSequence)("Source root doesn't exist: " + source));
        }
        if (sources.isEmpty()) {
            throw new MojoExecutionException("No source roots to compile");
        }
        ((CommonCompilerArguments)arguments).suppressWarnings = this.nowarn;
        this.getLog().info((CharSequence)("Compiling Kotlin sources from " + sources));
        this.configureSpecificCompilerArguments(arguments);
        try {
            compiler.parseArguments(ArrayUtil.toStringArray(this.args), arguments);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        ((CommonCompilerArguments)arguments).freeArgs.addAll(sources);
        if (((CommonCompilerArguments)arguments).noInline) {
            this.getLog().info((CharSequence)"Method inlining is turned off");
        }
    }
}

