/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

public class MavenPluginLogMessageCollector
implements MessageCollector {
    private final Log log;
    private boolean hasErrors = false;

    public MavenPluginLogMessageCollector(Log log) {
        this.log = log;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        String path = location.getPath();
        String position = path == null ? "" : path + ": (" + location.getLine() + ", " + location.getColumn() + ") ";
        String text = position + message;
        if (CompilerMessageSeverity.VERBOSE.contains(severity)) {
            this.log.debug((CharSequence)text);
        } else if (CompilerMessageSeverity.ERRORS.contains(severity)) {
            this.hasErrors = true;
            this.log.error((CharSequence)text);
        } else if (severity == CompilerMessageSeverity.INFO) {
            this.log.info((CharSequence)text);
        } else {
            this.log.warn((CharSequence)text);
        }
    }
}

