/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.google.common.base.Preconditions;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.maven.KotlinCompilationFailureException;

public class MavenPluginLogMessageCollector
implements MessageCollector {
    private final Log log;
    private final ArrayList<Pair<CompilerMessageLocation, String>> collectedErrors = new ArrayList();

    public MavenPluginLogMessageCollector(Log log) {
        this.log = (Log)Preconditions.checkNotNull((Object)log, (Object)"log shouldn't be null");
    }

    public boolean hasErrors() {
        return !this.collectedErrors.isEmpty();
    }

    @NotNull
    public List<Pair<CompilerMessageLocation, String>> getCollectedErrors() {
        return Collections.unmodifiableList(this.collectedErrors);
    }

    public void clear() {
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        String path = location.getPath();
        String position = path == null ? "" : path + ": (" + location.getLine() + ", " + location.getColumn() + ") ";
        String text = position + message;
        if (CompilerMessageSeverity.VERBOSE.contains(severity)) {
            this.log.debug((CharSequence)text);
        } else if (CompilerMessageSeverity.ERRORS.contains(severity)) {
            this.collectedErrors.add((Pair<CompilerMessageLocation, String>)new Pair((Object)location, (Object)message));
            this.log.error((CharSequence)text);
        } else if (severity == CompilerMessageSeverity.INFO) {
            this.log.info((CharSequence)text);
        } else {
            this.log.warn((CharSequence)text);
        }
    }

    public void throwKotlinCompilerException() throws KotlinCompilationFailureException {
        throw new KotlinCompilationFailureException(CollectionsKt.map(this.getCollectedErrors(), (Function1)new Function1<Pair<CompilerMessageLocation, String>, CompilerMessage>(){

            public CompilerMessage invoke(Pair<CompilerMessageLocation, String> pair) {
                CompilerMessageLocation location = (CompilerMessageLocation)pair.getFirst();
                String message = (String)pair.getSecond();
                String lineContent = location.getLineContent();
                int lineContentLength = lineContent == null ? 0 : lineContent.length();
                return new CompilerMessage(location.getPath(), CompilerMessage.Kind.ERROR, MavenPluginLogMessageCollector.fixLocation(location.getLine()), MavenPluginLogMessageCollector.fixLocation(location.getColumn()), MavenPluginLogMessageCollector.fixLocation(location.getLine()), Math.min(MavenPluginLogMessageCollector.fixLocation(location.getColumn()), lineContentLength), message);
            }
        }));
    }

    private static int fixLocation(int n) {
        if (n < 0) {
            return 0;
        }
        return n;
    }
}

