/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven.kapt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.DependencyCoordinate;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationProcessingManager {
    private final ArtifactHandlerManager artifactHandlerManager;
    private final MavenSession session;
    private final MavenProject project;
    private final RepositorySystem repositorySystem;
    private final ResolutionErrorHandler resolutionErrorHandler;
    private static final DependencyCoordinate KAPT_DEPENDENCY = new DependencyCoordinate();
    public static final String COMPILE_SOURCE_SET_NAME = "compile";
    public static final String TEST_SOURCE_SET_NAME = "test";

    AnnotationProcessingManager(@NotNull ArtifactHandlerManager artifactHandlerManager, @NotNull MavenSession session, @NotNull MavenProject project, @NotNull RepositorySystem repositorySystem, @NotNull ResolutionErrorHandler resolutionErrorHandler) {
        this.artifactHandlerManager = artifactHandlerManager;
        this.session = session;
        this.project = project;
        this.repositorySystem = repositorySystem;
        this.resolutionErrorHandler = resolutionErrorHandler;
    }

    @NotNull
    public static File getGeneratedSourcesDirectory(@NotNull MavenProject project, @NotNull String sourceSetName) {
        return new File(AnnotationProcessingManager.getTargetDirectory(project), "generated-sources/kapt/" + sourceSetName);
    }

    @NotNull
    static File getStubsDirectory(@NotNull MavenProject project, @NotNull String sourceSetName) {
        return new File(AnnotationProcessingManager.getTargetDirectory(project), "kaptStubs/" + sourceSetName);
    }

    @NotNull
    static File getGeneratedClassesDirectory(@NotNull MavenProject project, @NotNull String sourceSetName) {
        if (sourceSetName.equals(COMPILE_SOURCE_SET_NAME)) {
            return new File(project.getModel().getBuild().getOutputDirectory());
        }
        if (sourceSetName.equals(TEST_SOURCE_SET_NAME)) {
            return new File(project.getModel().getBuild().getTestOutputDirectory());
        }
        throw new IllegalArgumentException("'compile' or 'test' expected");
    }

    @NotNull
    private static File getTargetDirectory(@NotNull MavenProject project) {
        return new File(project.getModel().getBuild().getDirectory());
    }

    @NotNull
    ResolvedArtifacts resolveAnnotationProcessors(@Nullable List<DependencyCoordinate> aptDependencies) throws Exception {
        if (aptDependencies == null) {
            aptDependencies = Collections.emptyList();
        }
        LinkedHashSet<Artifact> requiredArtifacts = new LinkedHashSet<Artifact>();
        requiredArtifacts.add(this.getArtifact(this.artifactHandlerManager, KAPT_DEPENDENCY));
        for (DependencyCoordinate dependencyCoordinate : aptDependencies) {
            requiredArtifacts.add(this.getArtifact(this.artifactHandlerManager, dependencyCoordinate));
        }
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact((Artifact)requiredArtifacts.iterator().next()).setResolveRoot(true).setResolveTransitively(true).setArtifactDependencies(requiredArtifacts).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        ArtifactResolutionResult artifactResolutionResult = this.repositorySystem.resolve(request);
        this.resolutionErrorHandler.throwErrors(request, artifactResolutionResult);
        if (artifactResolutionResult == null || artifactResolutionResult.getArtifacts() == null) {
            throw new IllegalStateException("Annotation processing artifacts were not resolved.");
        }
        ArrayList<String> apClasspath = new ArrayList<String>(artifactResolutionResult.getArtifacts().size());
        String kaptCompilerPluginArtifact = null;
        for (Artifact artifact : artifactResolutionResult.getArtifacts()) {
            if (artifact == null) continue;
            if (artifact.getGroupId().equals(KAPT_DEPENDENCY.getGroupId()) && artifact.getArtifactId().equals(KAPT_DEPENDENCY.getArtifactId())) {
                kaptCompilerPluginArtifact = artifact.getFile().getAbsolutePath();
                continue;
            }
            apClasspath.add(artifact.getFile().getAbsolutePath());
        }
        if (kaptCompilerPluginArtifact == null) {
            throw new IllegalStateException("Kapt compiler plugin artifact was not resolved.");
        }
        return new ResolvedArtifacts(apClasspath, kaptCompilerPluginArtifact);
    }

    @NotNull
    private Artifact getArtifact(@NotNull ArtifactHandlerManager artifactHandlerManager, @NotNull DependencyCoordinate dependency) throws Exception {
        ArtifactHandler handler = artifactHandlerManager.getArtifactHandler(dependency.getType());
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), VersionRange.createFromVersionSpec((String)dependency.getVersion()), "runtime", dependency.getType(), dependency.getClassifier(), handler, false);
    }

    @NotNull
    private static String getMavenPluginVersion() throws MojoExecutionException {
        ClassLoader classLoader = AnnotationProcessingManager.class.getClassLoader();
        InputStream pomPropertiesIs = classLoader.getResourceAsStream("META-INF/maven/org.jetbrains.kotlin/kotlin-maven-plugin/pom.properties");
        if (pomPropertiesIs == null) {
            throw new MojoExecutionException("Can't resolve the version of kotlin-maven-plugin");
        }
        Properties properties = new Properties();
        try {
            properties.load(pomPropertiesIs);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading kotlin-maven-plugin/pom.properties", (Exception)e);
        }
        return properties.getProperty("version");
    }

    static {
        KAPT_DEPENDENCY.setGroupId("org.jetbrains.kotlin");
        KAPT_DEPENDENCY.setArtifactId("kotlin-annotation-processing-maven");
        try {
            KAPT_DEPENDENCY.setVersion(AnnotationProcessingManager.getMavenPluginVersion());
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    class ResolvedArtifacts {
        @NotNull
        final List<String> annotationProcessingClasspath;
        @NotNull
        final String kaptCompilerPluginArtifact;

        ResolvedArtifacts(@NotNull List<String> annotationProcessingClasspath, String kaptCompilerPluginArtifact) {
            this.annotationProcessingClasspath = annotationProcessingClasspath;
            this.kaptCompilerPluginArtifact = kaptCompilerPluginArtifact;
        }
    }
}

