/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven.kapt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.DependencyCoordinate;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.maven.K2JVMCompileMojo;
import org.jetbrains.kotlin.maven.kapt.AnnotationProcessingManager;
import org.jetbrains.kotlin.maven.kapt.KaptOption;

@Mojo(name="kapt", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class KaptJVMCompilerMojo
extends K2JVMCompileMojo {
    @Parameter
    private String[] annotationProcessors;
    @Parameter
    private List<DependencyCoordinate> annotationProcessorPaths;
    @Parameter
    private boolean useLightAnalysis = true;
    @Parameter
    private boolean correctErrorTypes = false;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ResolutionErrorHandler resolutionErrorHandler;
    private AnnotationProcessingManager cachedAnnotationProcessingManager;

    private AnnotationProcessingManager getAnnotationProcessingManager() {
        if (this.cachedAnnotationProcessingManager != null) {
            return this.cachedAnnotationProcessingManager;
        }
        this.cachedAnnotationProcessingManager = new AnnotationProcessingManager(this.artifactHandlerManager, this.session, this.project, this.system, this.resolutionErrorHandler);
        return this.cachedAnnotationProcessingManager;
    }

    @NotNull
    private List<KaptOption> getKaptOptions(@NotNull K2JVMCompilerArguments arguments, @NotNull AnnotationProcessingManager.ResolvedArtifacts resolvedArtifacts) {
        ArrayList<KaptOption> options = new ArrayList<KaptOption>();
        options.add(new KaptOption("aptOnly", true));
        options.add(new KaptOption("useLightAnalysis", this.useLightAnalysis));
        options.add(new KaptOption("correctErrorTypes", this.correctErrorTypes));
        options.add(new KaptOption("processors", this.annotationProcessors));
        if (arguments.verbose) {
            options.add(new KaptOption("verbose", true));
        }
        for (String entry : resolvedArtifacts.annotationProcessingClasspath) {
            options.add(new KaptOption("apclasspath", entry));
        }
        String sourceSetName = this.getSourceSetName();
        File sourcesDirectory = AnnotationProcessingManager.getGeneratedSourcesDirectory(this.project, sourceSetName);
        File classesDirectory = AnnotationProcessingManager.getGeneratedClassesDirectory(this.project, sourceSetName);
        File stubsDirectory = AnnotationProcessingManager.getStubsDirectory(this.project, sourceSetName);
        this.addKaptSourcesDirectory(sourcesDirectory.getPath());
        this.mkdirsSafe(sourcesDirectory);
        this.mkdirsSafe(classesDirectory);
        this.mkdirsSafe(stubsDirectory);
        options.add(new KaptOption("sources", sourcesDirectory.getAbsolutePath()));
        options.add(new KaptOption("classes", classesDirectory.getAbsolutePath()));
        options.add(new KaptOption("stubs", stubsDirectory.getAbsolutePath()));
        return options;
    }

    protected void addKaptSourcesDirectory(@NotNull String path) {
        this.project.addCompileSourceRoot(path);
    }

    private void mkdirsSafe(@NotNull File directory) {
        if (!directory.mkdirs()) {
            this.getLog().warn((CharSequence)("Unable to create directory " + directory));
        }
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JVMCompilerArguments arguments) throws MojoExecutionException {
        String[] stringArray;
        AnnotationProcessingManager.ResolvedArtifacts resolvedArtifacts;
        super.configureSpecificCompilerArguments(arguments);
        try {
            resolvedArtifacts = this.getAnnotationProcessingManager().resolveAnnotationProcessors(this.annotationProcessorPaths);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while processing kapt options", e);
        }
        String[] kaptOptions = this.renderKaptOptions(this.getKaptOptions(arguments, resolvedArtifacts));
        arguments.pluginOptions = this.joinArrays(arguments.pluginOptions, kaptOptions);
        String jdkToolsJarPath = this.getJdkToolsJarPath();
        String[] stringArray2 = arguments.pluginClasspaths;
        if (jdkToolsJarPath == null) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = resolvedArtifacts.kaptCompilerPluginArtifact;
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = jdkToolsJarPath;
            stringArray = stringArray4;
            stringArray4[1] = resolvedArtifacts.kaptCompilerPluginArtifact;
        }
        arguments.pluginClasspaths = this.joinArrays(stringArray2, stringArray);
    }

    @Nullable
    private String getJdkToolsJarPath() {
        String javaHomePath = System.getProperty("java.home");
        if (javaHomePath == null || javaHomePath.isEmpty()) {
            this.getLog().warn((CharSequence)"Can't determine Java home, 'java.home' property does not exist");
            return null;
        }
        File javaHome = new File(javaHomePath);
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return toolsJar.getAbsolutePath();
        }
        if (javaHome.getName().equals("jre") && (toolsJar = new File(javaHome.getParent(), "lib/tools.jar")).exists()) {
            return toolsJar.getAbsolutePath();
        }
        this.getLog().debug((CharSequence)(toolsJar.getAbsolutePath() + " does not exist"));
        this.getLog().warn((CharSequence)"'tools.jar' was not found, kapt may work unreliably");
        return null;
    }

    @NotNull
    private String[] renderKaptOptions(@NotNull List<KaptOption> options) {
        String[] result = new String[options.size()];
        int i = 0;
        for (KaptOption option : options) {
            result[i++] = option.toString();
        }
        return result;
    }

    @NotNull
    private String[] joinArrays(@Nullable String[] first, @Nullable String[] second) {
        if (first == null) {
            first = new String[]{};
        }
        if (second == null) {
            second = new String[]{};
        }
        String[] result = new String[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    @Override
    protected boolean isIncremental() {
        return false;
    }
}

