/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.maven.MetadataMojo;

@Mojo(name="test-metadata", defaultPhase=LifecyclePhase.PROCESS_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class TestMetadataMojo
extends MetadataMojo {
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;

    @Override
    protected List<String> getSourceFilePaths() {
        return this.project.getTestCompileSourceRoots();
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2MetadataCompilerArguments arguments, @NotNull List<File> sourceRoots) throws MojoExecutionException {
        String productionOutput = this.output;
        this.classpath = this.testClasspath;
        this.output = this.testOutput;
        super.configureSpecificCompilerArguments(arguments, sourceRoots);
        arguments.classpath = arguments.classpath == null ? productionOutput : arguments.classpath + File.pathSeparator + productionOutput;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Test compilation is skipped");
        } else {
            super.execute();
        }
    }
}

