/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven.incremental;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.incremental.ICReporterBase;

public class MavenICReporter
extends ICReporterBase {
    private static final String IC_LOG_LEVEL_PROPERTY_NAME = "kotlin.compiler.incremental.log.level";
    private final Log log;
    private final LogLevel logLevel;
    @NotNull
    private final Set<File> compiledKotlinFiles = new HashSet<File>();

    public MavenICReporter(@NotNull Log log) {
        super(null);
        LogLevel logLevel = log.isDebugEnabled() ? LogLevel.DEBUG : (log.isInfoEnabled() ? LogLevel.INFO : LogLevel.NONE);
        String userLogLevel = System.getProperty(IC_LOG_LEVEL_PROPERTY_NAME);
        if (userLogLevel != null) {
            for (LogLevel enumEntry : LogLevel.values()) {
                if (!enumEntry.name().equalsIgnoreCase(userLogLevel)) continue;
                logLevel = enumEntry;
                break;
            }
            log.warn((CharSequence)("Unknown incremental compilation log level '" + (Object)((Object)logLevel) + "',possible values: 'none', 'info', 'debug'"));
        }
        this.logLevel = logLevel;
        this.log = log;
    }

    public void report(@NotNull Function0<String> getMessage) {
        switch (this.logLevel) {
            case NONE: {
                break;
            }
            case INFO: {
                this.log.info((CharSequence)getMessage.invoke());
                break;
            }
            case DEBUG: {
                this.log.debug((CharSequence)getMessage.invoke());
            }
        }
    }

    public void reportVerbose(@NotNull Function0<String> getMessage) {
        if (this.logLevel == LogLevel.DEBUG) {
            this.log.debug((CharSequence)getMessage.invoke());
        }
    }

    @NotNull
    public Set<File> getCompiledKotlinFiles() {
        return this.compiledKotlinFiles;
    }

    public void reportCompileIteration(boolean b, @NotNull Collection<? extends File> sourceFiles, @NotNull ExitCode exitCode) {
        this.compiledKotlinFiles.addAll(sourceFiles);
        this.report((Function0<String>)((Function0)() -> "Kotlin compile iteration: " + this.pathsAsString(sourceFiles)));
        this.report((Function0<String>)((Function0)() -> "Exit code: " + exitCode.toString()));
    }

    private static enum LogLevel {
        NONE,
        INFO,
        DEBUG;

    }
}

