/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.SourcesUtilsKt;
import org.jetbrains.kotlin.buildtools.api.BuildOperation;
import org.jetbrains.kotlin.buildtools.api.CompilationResult;
import org.jetbrains.kotlin.buildtools.api.ExecutionPolicy;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.buildtools.api.KotlinToolchains;
import org.jetbrains.kotlin.buildtools.api.SourcesChanges;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmPlatformToolchain;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmSnapshotBasedIncrementalCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmSnapshotBasedIncrementalCompilationOptions;
import org.jetbrains.kotlin.buildtools.api.jvm.operations.JvmCompilationOperation;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.maven.ClassLoaderCache;
import org.jetbrains.kotlin.maven.KotlinArtifactResolver;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;
import org.jetbrains.kotlin.maven.LegacyKotlinMavenLogger;
import org.jetbrains.kotlin.maven.SharedBuildToolsApiClassesClassLoaderProvider;
import org.jetbrains.kotlin.maven.Util;
import org.jetbrains.kotlin.maven.incremental.FileCopier;
import org.jetbrains.kotlin.maven.kapt.AnnotationProcessingManager;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class K2JVMCompileMojo
extends KotlinCompileMojoBase<K2JVMCompilerArguments> {
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    public List<String> classpath;
    @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
    protected List<String> testClasspath;
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    protected String moduleName;
    @Parameter(defaultValue="${project.artifactId}-test", required=true, readonly=true)
    protected String testModuleName;
    @Parameter(property="kotlin.compiler.jvmTarget")
    protected String jvmTarget;
    @Parameter(property="kotlin.compiler.jdkHome")
    protected String jdkHome;
    @Parameter(property="kotlin.compiler.scriptTemplates")
    protected List<String> scriptTemplates;
    @Parameter(property="kotlin.compiler.incremental", defaultValue="false")
    private boolean myIncremental;
    @Parameter(property="kotlin.compiler.incremental.cache.root", defaultValue="${project.build.directory}/kotlin-ic")
    public String incrementalCachesRoot;
    @Parameter(property="kotlin.compiler.javaParameters")
    protected boolean javaParameters;
    @Parameter(property="kotlin.compiler.daemon", defaultValue="true")
    protected boolean useDaemon;
    @Parameter(property="kotlin.compiler.classloader.cache.timeoutSeconds")
    @Nullable
    protected Long classLoaderCacheTimeoutSeconds;
    private static final Duration DEFAULT_CLASSLOADER_CACHE_TIMEOUT = Duration.ofMinutes(30L);
    @Parameter(property="kotlin.compiler.daemon.jvmArgs")
    protected List<String> kotlinDaemonJvmArgs;
    @Parameter(property="kotlin.compiler.daemon.shutdownDelayMs")
    protected Long daemonShutdownDelayMs;
    private static final Duration DEFAULT_NON_MAVEN_DAEMON_SHUTDOWN_DELAY = Duration.ofMinutes(30L);
    private static final Duration DEFAULT_MAVEN_DAEMON_SHUTDOWN_DELAY = Duration.ofSeconds(1L);
    private static final String MAVEN_DAEMON_PROPERTY_NAME = "mvnd.home";
    @Inject
    private KotlinArtifactResolver kotlinArtifactResolver;

    @NotNull
    private Path getCachesDir() {
        return Paths.get(this.incrementalCachesRoot, this.getSourceSetName());
    }

    @NotNull
    private Path getKotlinClassesCacheDir() {
        return this.getCachesDir().resolve("classes");
    }

    protected boolean isIncremental() {
        return this.myIncremental;
    }

    @NotNull
    protected K2JVMCompiler createCompiler() {
        return new K2JVMCompiler();
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createCompilerArguments() {
        return new K2JVMCompilerArguments();
    }

    @Override
    protected List<String> getSourceFilePaths() {
        File kotlinSourcesDir;
        ArrayList<String> paths = new ArrayList<String>(super.getSourceFilePaths());
        File sourcesDir = AnnotationProcessingManager.getGeneratedSourcesDirectory(this.project, this.getSourceSetName());
        if (sourcesDir.isDirectory()) {
            paths.add(sourcesDir.getAbsolutePath());
        }
        if ((kotlinSourcesDir = AnnotationProcessingManager.getGeneratedKotlinSourcesDirectory(this.project, this.getSourceSetName())).isDirectory()) {
            paths.add(kotlinSourcesDir.getAbsolutePath());
        }
        return paths;
    }

    protected List<String> getClasspath() {
        return Util.filterClassPath(this.project.getBasedir(), this.classpath);
    }

    @NotNull
    protected String getSourceSetName() {
        return "compile";
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JVMCompilerArguments arguments, @NotNull List<File> sourceRoots) throws MojoExecutionException {
        List<String> classpathList;
        arguments.setDestination(this.output);
        arguments.setNoStdlib(true);
        arguments.setJavaParameters(this.javaParameters);
        if (this.module != null || this.testModule != null) {
            this.getLog().warn((CharSequence)"Parameters module and testModule are deprecated and ignored, they will be removed in further release.");
        }
        if (!(classpathList = this.getClasspath()).isEmpty()) {
            String classPathString = StringUtil.join(classpathList, (String)File.pathSeparator);
            if (this.isJava9Module(sourceRoots)) {
                this.getLog().debug((CharSequence)("Module path: " + classPathString));
                arguments.setJavaModulePath(classPathString);
            } else {
                this.getLog().debug((CharSequence)("Classpath: " + classPathString));
                arguments.setClasspath(classPathString);
            }
        }
        this.getLog().debug((CharSequence)("Classes directory is " + this.output));
        arguments.setDestination(this.output);
        arguments.setModuleName(this.moduleName);
        this.getLog().debug((CharSequence)("Module name is " + this.moduleName));
        if (arguments.getNoOptimize()) {
            this.getLog().info((CharSequence)"Optimization is turned off");
        }
        if (this.jvmTarget != null) {
            arguments.setJvmTarget(this.jvmTarget);
        } else {
            arguments.setJvmTarget(JvmTarget.DEFAULT.getDescription());
        }
        if (this.jdkHome != null) {
            this.getLog().info((CharSequence)("Overriding JDK home path with: " + this.jdkHome));
            arguments.setJdkHome(this.jdkHome);
        }
        if (this.scriptTemplates != null && !this.scriptTemplates.isEmpty()) {
            arguments.setScriptTemplates(this.scriptTemplates.toArray(new String[0]));
        }
    }

    private boolean isJava9Module(@NotNull List<File> sourceRoots) {
        return sourceRoots.stream().anyMatch(file -> file.getName().equals("module-info.java") || file.isDirectory() && Arrays.stream(file.listFiles()).anyMatch(child -> child.getName().equals("module-info.java")));
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.args != null && this.args.contains("-Xuse-javac")) {
            try {
                URL toolsJar = this.getJdkToolsJarURL();
                if (toolsJar != null) {
                    this.project.getClassRealm().addURL(toolsJar);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.execute();
    }

    private KotlinToolchains getKotlinToolchains() throws MojoExecutionException {
        try {
            Set artifacts = Stream.concat(this.kotlinArtifactResolver.resolveArtifact("org.jetbrains.kotlin", "kotlin-build-tools-impl", Util.getMavenPluginVersion()).stream(), this.kotlinArtifactResolver.resolveArtifact("org.jetbrains.kotlin", "kotlin-scripting-compiler-embeddable", Util.getMavenPluginVersion()).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
            List<File> files = artifacts.stream().map(Artifact::getFile).collect(Collectors.toList());
            ClassLoader btaClassLoader = this.getBtaClassLoader(files);
            return KotlinToolchains.loadImplementation((ClassLoader)btaClassLoader);
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Failed to load Kotlin Build Tools API implementation", t);
        }
    }

    private ClassLoader getBtaClassLoader(List<File> files) {
        ClassLoaderCache.ClassLoaderCacheKey cacheKey = new ClassLoaderCache.ClassLoaderCacheKey(files, new SharedBuildToolsApiClassesClassLoaderProvider());
        try {
            long cacheTimeout = this.classLoaderCacheTimeoutSeconds == null ? DEFAULT_CLASSLOADER_CACHE_TIMEOUT.getSeconds() : this.classLoaderCacheTimeoutSeconds.longValue();
            return (ClassLoader)ClassLoaderCache.getCache(cacheTimeout).get((Object)cacheKey, () -> {
                this.getLog().debug((CharSequence)("Creating classloader for " + cacheKey.getClasspath()));
                URL[] urls = (URL[])cacheKey.getClasspath().stream().map(file -> {
                    try {
                        return file.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }).toArray(URL[]::new);
                return new URLClassLoader(urls, cacheKey.getParentClassLoaderProvider().getClassLoader());
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFileExtension(Path file) {
        String fileName = file.getFileName().toString();
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return "";
        }
        return fileName.substring(lastDotIndex + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected ExitCode execCompiler(CLICompiler<K2JVMCompilerArguments> compiler, MessageCollector messageCollector, K2JVMCompilerArguments arguments, List<File> sourceRoots) throws MojoExecutionException {
        try {
            ExecutionPolicy.InProcess executionPolicy;
            KotlinToolchains kotlinToolchains = this.getKotlinToolchains();
            if (this.useDaemon) {
                boolean inMavenDaemon;
                boolean bl = inMavenDaemon = System.getProperty(MAVEN_DAEMON_PROPERTY_NAME) != null;
                Duration usedDaemonShutdownDelay = this.daemonShutdownDelayMs != null ? Duration.ofMillis(this.daemonShutdownDelayMs) : (inMavenDaemon ? DEFAULT_MAVEN_DAEMON_SHUTDOWN_DELAY : DEFAULT_NON_MAVEN_DAEMON_SHUTDOWN_DELAY);
                this.getLog().debug((CharSequence)("Using Kotlin compiler daemon with shutdown delay " + usedDaemonShutdownDelay + " ms" + (inMavenDaemon ? " (in Maven daemon)" : " (outside Maven daemon)")));
                ExecutionPolicy.WithDaemon daemonPolicy = kotlinToolchains.createDaemonExecutionPolicy();
                daemonPolicy.set(ExecutionPolicy.WithDaemon.JVM_ARGUMENTS, this.kotlinDaemonJvmArgs);
                daemonPolicy.set(ExecutionPolicy.WithDaemon.SHUTDOWN_DELAY_MILLIS, (Object)usedDaemonShutdownDelay.toMillis());
                executionPolicy = daemonPolicy;
            } else {
                this.getLog().debug((CharSequence)"Using in-process Kotlin compiler");
                executionPolicy = kotlinToolchains.createInProcessExecutionPolicy();
            }
            JvmPlatformToolchain jvmToolchain = JvmPlatformToolchain.from((KotlinToolchains)kotlinToolchains);
            Set kotlinExtensions = SourcesUtilsKt.getDEFAULT_KOTLIN_SOURCE_FILES_EXTENSIONS();
            HashSet<String> allExtensions = new HashSet<String>(kotlinExtensions);
            allExtensions.add("java");
            ArrayList allSources = new ArrayList();
            for (File sourceRoot : sourceRoots) {
                Stream<Path> files = Files.walk(sourceRoot.toPath(), new FileVisitOption[0]);
                try {
                    allSources.addAll(files.filter(file -> allExtensions.contains(K2JVMCompileMojo.getFileExtension(file).toLowerCase(Locale.ROOT))).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList()));
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
            List myArguments = ArgumentUtils.convertArgumentsToStringList((CommonToolArguments)arguments);
            HashSet<Consumer<CompilationResult>> resultHandlers = new HashSet<Consumer<CompilationResult>>();
            Path destination = this.getEffectiveDestinationDirectory(arguments);
            JvmCompilationOperation compilationOperation = jvmToolchain.createJvmCompilationOperation(allSources, destination);
            if (this.isIncremental()) {
                resultHandlers.add(this.configureIncrementalCompilation(compilationOperation, arguments));
            }
            LegacyKotlinMavenLogger kotlinMavenLogger = new LegacyKotlinMavenLogger(messageCollector, this.getLog());
            try (KotlinToolchains.BuildSession buildSession = kotlinToolchains.createBuildSession();){
                compilationOperation.getCompilerArguments().applyArgumentStrings(myArguments);
                CompilationResult result = (CompilationResult)buildSession.executeOperation((BuildOperation)compilationOperation, (ExecutionPolicy)executionPolicy, (KotlinLogger)kotlinMavenLogger);
                resultHandlers.forEach(handler -> handler.accept(result));
                switch (result) {
                    case COMPILATION_SUCCESS: {
                        ExitCode exitCode = ExitCode.OK;
                        return exitCode;
                    }
                    case COMPILATION_ERROR: {
                        ExitCode exitCode = ExitCode.COMPILATION_ERROR;
                        return exitCode;
                    }
                    case COMPILATION_OOM_ERROR: {
                        ExitCode exitCode = ExitCode.OOM_ERROR;
                        return exitCode;
                    }
                }
                ExitCode exitCode = ExitCode.INTERNAL_ERROR;
                return exitCode;
            }
        }
        catch (Throwable t) {
            this.getLog().error((CharSequence)"Internal Kotlin compilation error", t);
            return ExitCode.INTERNAL_ERROR;
        }
    }

    private Path getEffectiveDestinationDirectory(K2JVMCompilerArguments arguments) {
        if (this.isIncremental()) {
            return this.getKotlinClassesCacheDir();
        }
        String destination = Objects.requireNonNull(arguments.getDestination());
        return Paths.get(destination, new String[0]);
    }

    private Consumer<CompilationResult> configureIncrementalCompilation(JvmCompilationOperation compileOperation, K2JVMCompilerArguments arguments) throws IOException {
        this.getLog().warn((CharSequence)"Using experimental Kotlin incremental compilation");
        Path cachesDir = this.getCachesDir();
        Files.createDirectories(cachesDir, new FileAttribute[0]);
        String originalDestination = arguments.getDestination();
        assert (originalDestination != null) : "output is not specified!";
        File classesDir = new File(originalDestination);
        File kotlinClassesDir = this.getKotlinClassesCacheDir().toFile();
        File snapshotsFile = new File(cachesDir.toFile(), "snapshots.bin");
        String originalClasspath = arguments.getClasspath();
        if (originalClasspath != null) {
            ArrayList<String> filteredClasspath = new ArrayList<String>();
            for (String path : originalClasspath.split(File.pathSeparator)) {
                if (classesDir.equals(new File(path))) continue;
                filteredClasspath.add(path);
            }
            arguments.setClasspath(StringUtil.join(filteredClasspath, (String)File.pathSeparator));
        }
        JvmSnapshotBasedIncrementalCompilationOptions classpathSnapshotsOptions = compileOperation.createSnapshotBasedIcOptions();
        compileOperation.set(JvmCompilationOperation.INCREMENTAL_COMPILATION, (Object)new JvmSnapshotBasedIncrementalCompilationConfiguration(cachesDir, (SourcesChanges)SourcesChanges.ToBeCalculated.INSTANCE, Collections.EMPTY_LIST, cachesDir.resolve("shrunk-classpath-snapshot.bin"), classpathSnapshotsOptions));
        return compilationResult -> {
            if (compilationResult == CompilationResult.COMPILATION_SUCCESS) {
                new FileCopier(this.getLog()).syncDirs(kotlinClassesDir, classesDir, snapshotsFile);
            }
            arguments.setClasspath(originalClasspath);
        };
    }

    @Nullable
    private URL getJdkToolsJarURL() throws IOException {
        String javaHomePath = System.getProperty("java.home");
        if (javaHomePath == null || javaHomePath.isEmpty()) {
            return null;
        }
        File javaHome = new File(javaHomePath);
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return toolsJar.getCanonicalFile().toURI().toURL();
        }
        if (javaHome.getName().equals("jre") && (toolsJar = new File(javaHome.getParent(), "lib/tools.jar")).exists()) {
            return toolsJar.getCanonicalFile().toURI().toURL();
        }
        return null;
    }
}

