/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// Auto-generated file. DO NOT EDIT!
// Generated by org.jetbrains.kotlin.generators.builtins.arrays.GenerateNativeArrays

package kotlin

import kotlin.native.internal.*
import kotlin.native.internal.escapeAnalysis.Escapes
import kotlin.native.internal.escapeAnalysis.PointsTo

/**
 * A generic array of objects.
 * Array instances can be created using the [arrayOf], [arrayOfNulls] and [emptyArray]
 * standard library functions.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
@ExportTypeInfo("theArrayTypeInfo")
public actual class Array<T> {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("TYPE_PARAMETER_AS_REIFIED", "WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> T) : this(size) {
        for (i in 0..size - 1) {
            this[i] = init(i)
        }
    }

    @PublishedApi
    @ExportForCompiler
    internal constructor(@Suppress("UNUSED_PARAMETER") size: Int) {}

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_Array_get")
    @PointsTo(0x000, 0x000, 0x002) // ret -> this.intestines
    public actual external operator fun get(index: Int): T

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_Array_set")
    @PointsTo(0x0300, 0x0000, 0x0000, 0x0000) // this.intestines -> value
    public actual external operator fun set(index: Int, value: T): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int
        get() = getArrayLength()

    /** Creates an [Iterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): Iterator<T> =
        ArrayIterator(this)

    @GCUnsafeCall("Kotlin_Array_getArrayLength")
    @Escapes.Nothing
    private external fun getArrayLength(): Int
}

private class ArrayIterator<T> constructor(val array: Array<T>) : Iterator<T> {
    private var index = 0
    override fun hasNext() = index < array.size
    override fun next() = if (index < array.size) array[index++] else throw NoSuchElementException("$index")
}
