/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// Auto-generated file. DO NOT EDIT!
// Generated by org.jetbrains.kotlin.generators.builtins.arrays.GenerateNativeArrays

package kotlin

import kotlin.native.internal.*
import kotlin.native.internal.escapeAnalysis.Escapes

/**
 * An array of bytes.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
@ExportTypeInfo("theByteArrayTypeInfo")
public actual class ByteArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
@Suppress("UNUSED_PARAMETER")
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("TYPE_PARAMETER_AS_REIFIED", "WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Byte) : this(size) {
        for (i in 0..size - 1) {
            this[i] = init(i)
        }
    }

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_ByteArray_get")
    @Escapes.Nothing
    public actual external operator fun get(index: Int): Byte

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_ByteArray_set")
    @Escapes.Nothing
    public actual external operator fun set(index: Int, value: Byte): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int
        get() = getArrayLength()

    /** Creates a specialized [ByteIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): ByteIterator =
        ByteArrayIterator(this)

    @GCUnsafeCall("Kotlin_ByteArray_getArrayLength")
    @Escapes.Nothing
    private external fun getArrayLength(): Int
}

private class ByteArrayIterator constructor(val array: ByteArray) : ByteIterator() {
    private var index = 0
    override fun hasNext() = index < array.size
    override fun nextByte() = if (index < array.size) array[index++] else throw NoSuchElementException("$index")
}

/**
 * An array of chars.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
@ExportTypeInfo("theCharArrayTypeInfo")
public actual class CharArray
/**
 * Creates a new array of the specified [size], with all elements initialized to null char (`\u0000').
 * @throws RuntimeException if the specified [size] is negative.
 */
@Suppress("UNUSED_PARAMETER")
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("TYPE_PARAMETER_AS_REIFIED", "WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Char) : this(size) {
        for (i in 0..size - 1) {
            this[i] = init(i)
        }
    }

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_CharArray_get")
    @Escapes.Nothing
    public actual external operator fun get(index: Int): Char

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_CharArray_set")
    @Escapes.Nothing
    public actual external operator fun set(index: Int, value: Char): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int
        get() = getArrayLength()

    /** Creates a specialized [CharIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): CharIterator =
        CharArrayIterator(this)

    @GCUnsafeCall("Kotlin_CharArray_getArrayLength")
    @Escapes.Nothing
    private external fun getArrayLength(): Int
}

private class CharArrayIterator constructor(val array: CharArray) : CharIterator() {
    private var index = 0
    override fun hasNext() = index < array.size
    override fun nextChar() = if (index < array.size) array[index++] else throw NoSuchElementException("$index")
}

/**
 * An array of shorts.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
@ExportTypeInfo("theShortArrayTypeInfo")
public actual class ShortArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
@Suppress("UNUSED_PARAMETER")
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("TYPE_PARAMETER_AS_REIFIED", "WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Short) : this(size) {
        for (i in 0..size - 1) {
            this[i] = init(i)
        }
    }

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_ShortArray_get")
    @Escapes.Nothing
    public actual external operator fun get(index: Int): Short

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_ShortArray_set")
    @Escapes.Nothing
    public actual external operator fun set(index: Int, value: Short): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int
        get() = getArrayLength()

    /** Creates a specialized [ShortIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): ShortIterator =
        ShortArrayIterator(this)

    @GCUnsafeCall("Kotlin_ShortArray_getArrayLength")
    @Escapes.Nothing
    private external fun getArrayLength(): Int
}

private class ShortArrayIterator constructor(val array: ShortArray) : ShortIterator() {
    private var index = 0
    override fun hasNext() = index < array.size
    override fun nextShort() = if (index < array.size) array[index++] else throw NoSuchElementException("$index")
}

/**
 * An array of ints.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
@ExportTypeInfo("theIntArrayTypeInfo")
public actual class IntArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
@Suppress("UNUSED_PARAMETER")
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("TYPE_PARAMETER_AS_REIFIED", "WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Int) : this(size) {
        for (i in 0..size - 1) {
            this[i] = init(i)
        }
    }

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_IntArray_get")
    @Escapes.Nothing
    public actual external operator fun get(index: Int): Int

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_IntArray_set")
    @Escapes.Nothing
    public actual external operator fun set(index: Int, value: Int): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int
        get() = getArrayLength()

    /** Creates a specialized [IntIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): IntIterator =
        IntArrayIterator(this)

    @GCUnsafeCall("Kotlin_IntArray_getArrayLength")
    @Escapes.Nothing
    private external fun getArrayLength(): Int
}

private class IntArrayIterator constructor(val array: IntArray) : IntIterator() {
    private var index = 0
    override fun hasNext() = index < array.size
    override fun nextInt() = if (index < array.size) array[index++] else throw NoSuchElementException("$index")
}

/**
 * An array of longs.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
@ExportTypeInfo("theLongArrayTypeInfo")
public actual class LongArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
@Suppress("UNUSED_PARAMETER")
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("TYPE_PARAMETER_AS_REIFIED", "WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Long) : this(size) {
        for (i in 0..size - 1) {
            this[i] = init(i)
        }
    }

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_LongArray_get")
    @Escapes.Nothing
    public actual external operator fun get(index: Int): Long

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_LongArray_set")
    @Escapes.Nothing
    public actual external operator fun set(index: Int, value: Long): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int
        get() = getArrayLength()

    /** Creates a specialized [LongIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): LongIterator =
        LongArrayIterator(this)

    @GCUnsafeCall("Kotlin_LongArray_getArrayLength")
    @Escapes.Nothing
    private external fun getArrayLength(): Int
}

private class LongArrayIterator constructor(val array: LongArray) : LongIterator() {
    private var index = 0
    override fun hasNext() = index < array.size
    override fun nextLong() = if (index < array.size) array[index++] else throw NoSuchElementException("$index")
}

/**
 * An array of floats.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
@ExportTypeInfo("theFloatArrayTypeInfo")
public actual class FloatArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
@Suppress("UNUSED_PARAMETER")
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("TYPE_PARAMETER_AS_REIFIED", "WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Float) : this(size) {
        for (i in 0..size - 1) {
            this[i] = init(i)
        }
    }

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_FloatArray_get")
    @Escapes.Nothing
    public actual external operator fun get(index: Int): Float

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_FloatArray_set")
    @Escapes.Nothing
    public actual external operator fun set(index: Int, value: Float): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int
        get() = getArrayLength()

    /** Creates a specialized [FloatIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): FloatIterator =
        FloatArrayIterator(this)

    @GCUnsafeCall("Kotlin_FloatArray_getArrayLength")
    @Escapes.Nothing
    private external fun getArrayLength(): Int
}

private class FloatArrayIterator constructor(val array: FloatArray) : FloatIterator() {
    private var index = 0
    override fun hasNext() = index < array.size
    override fun nextFloat() = if (index < array.size) array[index++] else throw NoSuchElementException("$index")
}

/**
 * An array of doubles.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
@ExportTypeInfo("theDoubleArrayTypeInfo")
public actual class DoubleArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
@Suppress("UNUSED_PARAMETER")
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("TYPE_PARAMETER_AS_REIFIED", "WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Double) : this(size) {
        for (i in 0..size - 1) {
            this[i] = init(i)
        }
    }

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_DoubleArray_get")
    @Escapes.Nothing
    public actual external operator fun get(index: Int): Double

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_DoubleArray_set")
    @Escapes.Nothing
    public actual external operator fun set(index: Int, value: Double): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int
        get() = getArrayLength()

    /** Creates a specialized [DoubleIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): DoubleIterator =
        DoubleArrayIterator(this)

    @GCUnsafeCall("Kotlin_DoubleArray_getArrayLength")
    @Escapes.Nothing
    private external fun getArrayLength(): Int
}

private class DoubleArrayIterator constructor(val array: DoubleArray) : DoubleIterator() {
    private var index = 0
    override fun hasNext() = index < array.size
    override fun nextDouble() = if (index < array.size) array[index++] else throw NoSuchElementException("$index")
}

/**
 * An array of booleans.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
@ExportTypeInfo("theBooleanArrayTypeInfo")
public actual class BooleanArray
/**
 * Creates a new array of the specified [size], with all elements initialized to `false`.
 * @throws RuntimeException if the specified [size] is negative.
 */
@Suppress("UNUSED_PARAMETER")
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("TYPE_PARAMETER_AS_REIFIED", "WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Boolean) : this(size) {
        for (i in 0..size - 1) {
            this[i] = init(i)
        }
    }

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_BooleanArray_get")
    @Escapes.Nothing
    public actual external operator fun get(index: Int): Boolean

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException].
     */
    @GCUnsafeCall("Kotlin_BooleanArray_set")
    @Escapes.Nothing
    public actual external operator fun set(index: Int, value: Boolean): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int
        get() = getArrayLength()

    /** Creates a specialized [BooleanIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): BooleanIterator =
        BooleanArrayIterator(this)

    @GCUnsafeCall("Kotlin_BooleanArray_getArrayLength")
    @Escapes.Nothing
    private external fun getArrayLength(): Int
}

private class BooleanArrayIterator constructor(val array: BooleanArray) : BooleanIterator() {
    private var index = 0
    override fun hasNext() = index < array.size
    override fun nextBoolean() = if (index < array.size) array[index++] else throw NoSuchElementException("$index")
}
