/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.noarg.diagnostic;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.extensions.AnnotationBasedExtension;
import org.jetbrains.kotlin.noarg.NoArgClassKeyKt;
import org.jetbrains.kotlin.noarg.diagnostic.ErrorsNoArg;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/noarg/diagnostic/AbstractNoArgDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "Lorg/jetbrains/kotlin/extensions/AnnotationBasedExtension;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isNoArgConstructor", "", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "kotlin-noarg"})
public abstract class AbstractNoArgDeclarationChecker
implements DeclarationChecker,
AnnotationBasedExtension {
    /*
     * WARNING - void declaration
     */
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        if (!(descriptor instanceof ClassDescriptor) || !(declaration instanceof KtClass)) {
            return;
        }
        if (Intrinsics.areEqual((Object)((ClassDescriptor)descriptor).getKind(), (Object)ClassKind.CLASS) ^ true) {
            return;
        }
        boolean hasSpecialAnnotation = this.hasSpecialAnnotation(descriptor, (KtModifierListOwner)declaration);
        declaration.putUserData(NoArgClassKeyKt.getNO_ARG_CLASS_KEY(), (Object)hasSpecialAnnotation);
        if (hasSpecialAnnotation) {
            boolean bl;
            ClassDescriptor superClass;
            block7: {
                void $receiver$iv;
                superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)((ClassDescriptor)descriptor));
                Iterable iterable = superClass.getConstructors();
                for (Object element$iv : $receiver$iv) {
                    ConstructorDescriptor it = (ConstructorDescriptor)element$iv;
                    if (!this.isNoArgConstructor(it)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (bl && !this.hasSpecialAnnotation((DeclarationDescriptor)superClass, (KtModifierListOwner)declaration)) {
                PsiElement psiElement;
                PsiElement psiElement2 = ((KtClass)declaration).getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = psiElement = ((KtClass)declaration).getClassOrInterfaceKeyword();
                }
                if (psiElement2 == null) {
                    psiElement = (PsiElement)declaration;
                }
                PsiElement reportTarget = psiElement;
                diagnosticHolder.report((Diagnostic)ErrorsNoArg.NO_NOARG_CONSTRUCTOR_IN_SUPERCLASS.on(reportTarget));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNoArgConstructor(@NotNull ConstructorDescriptor $receiver) {
        Object element$iv;
        ValueParameterDescriptor it;
        if ($receiver.getValueParameters().isEmpty()) return true;
        Iterable $receiver$iv = $receiver.getValueParameters();
        Iterator iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
        } while (DescriptorUtilsKt.hasDefaultValue((ValueParameterDescriptor)(it = (ValueParameterDescriptor)(element$iv = iterator.next()))));
        return false;
    }

    public boolean hasSpecialAnnotation(@NotNull DeclarationDescriptor $receiver, @NotNull KtModifierListOwner modifierListOwner) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)modifierListOwner, (String)"modifierListOwner");
        return AnnotationBasedExtension.DefaultImpls.hasSpecialAnnotation((AnnotationBasedExtension)this, (DeclarationDescriptor)$receiver, (KtModifierListOwner)modifierListOwner);
    }
}

