/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.noarg.diagnostic;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.extensions.AnnotationBasedExtension;
import org.jetbrains.kotlin.noarg.NoArgClassKeyKt;
import org.jetbrains.kotlin.noarg.diagnostic.DefaultErrorMessagesNoArg;
import org.jetbrains.kotlin.noarg.diagnostic.ErrorsNoArg;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/noarg/diagnostic/AbstractNoArgDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "Lorg/jetbrains/kotlin/extensions/AnnotationBasedExtension;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isNoArgConstructor", "", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "kotlin-noarg-compiler-plugin"})
public abstract class AbstractNoArgDeclarationChecker
implements DeclarationChecker,
AnnotationBasedExtension {
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(descriptor instanceof ClassDescriptor) || !(declaration instanceof KtClass)) {
            return;
        }
        if (((ClassDescriptor)descriptor).getKind() != ClassKind.CLASS) {
            return;
        }
        boolean hasSpecialAnnotation = this.hasSpecialAnnotation(descriptor, (KtModifierListOwner)declaration);
        declaration.putUserData(NoArgClassKeyKt.getNO_ARG_CLASS_KEY(), (Object)hasSpecialAnnotation);
        if (hasSpecialAnnotation) {
            boolean bl;
            ClassDescriptor superClass;
            block9: {
                superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)((ClassDescriptor)descriptor));
                Collection collection = superClass.getConstructors();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"superClass.constructors");
                Iterable $receiver$iv = collection;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ClassConstructorDescriptor it;
                        ClassConstructorDescriptor classConstructorDescriptor = it = (ClassConstructorDescriptor)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor, (String)"it");
                        if (!this.isNoArgConstructor((ConstructorDescriptor)classConstructorDescriptor)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl && !this.hasSpecialAnnotation((DeclarationDescriptor)superClass, (KtModifierListOwner)declaration)) {
                PsiElement psiElement;
                PsiElement psiElement2 = ((KtClass)declaration).getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = psiElement = ((KtClass)declaration).getClassOrInterfaceKeyword();
                }
                if (psiElement2 == null) {
                    psiElement = (PsiElement)declaration;
                }
                PsiElement reportTarget = psiElement;
                DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)context.getTrace()), (Diagnostic)((Diagnostic)ErrorsNoArg.NO_NOARG_CONSTRUCTOR_IN_SUPERCLASS.on(reportTarget)), (DefaultErrorMessages.Extension)DefaultErrorMessagesNoArg.INSTANCE);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNoArgConstructor(@NotNull ConstructorDescriptor $receiver) {
        ValueParameterDescriptor valueParameterDescriptor;
        if ($receiver.getValueParameters().isEmpty()) return true;
        List list = $receiver.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"valueParameters");
        Iterable $receiver$iv = list;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $receiver$iv.iterator();
        do {
            ValueParameterDescriptor it;
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            valueParameterDescriptor = it = (ValueParameterDescriptor)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
        } while (DescriptorUtilsKt.hasDefaultValue((ValueParameterDescriptor)valueParameterDescriptor));
        return false;
    }

    public boolean hasSpecialAnnotation(@NotNull DeclarationDescriptor $receiver, @Nullable KtModifierListOwner modifierListOwner) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return AnnotationBasedExtension.DefaultImpls.hasSpecialAnnotation((AnnotationBasedExtension)this, (DeclarationDescriptor)$receiver, (KtModifierListOwner)modifierListOwner);
    }
}

