/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.Charsets;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinMultifileClassPart;
import org.jetbrains.annotations.NotNull;

@KotlinMultifileClassPart(version={1, 0, 0}, abiVersion=32, data={"k\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!IQ!\u0001C\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\t\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005iA\u0002\u0003\u0001\u000e\u0003a\u0005Q#\u0001\r\u00023\u0013A\u0019!D\u0001\u0019\u0005A\u001b\t\u0001VB\u0003\u001bKA1!D\u0001\u0019\u0002U\t\u0001$AM\u0005\u0011\u000fi\u0011\u0001\u0007\u0003Q\u0007\u0003IZ\u0001B\u0001\t\n5\t\u0001$\u0002)\u0004\u0003Q\u001b)!d\t\t\u00075\t\u0001\u0014A\u000b\u00021\u0005IJ\u0001c\u0002\u000e\u0003a!\u0001k!\u0001\u001a\n!%Q\"\u0001\r\u0005!\u000e\tAk!\u0002\u000e\u001b!-Q\"\u0001\r\u0007+\u0005A\u0012!g\u0003\u0005\u0003!5Q\"\u0001\r\b!\u000e\u0005Ak!\u0002\u000e\u001b!=Q\"\u0001\r\t+\u0005A\u0012!g\u0003\u0005\u0003!5Q\"\u0001\r\b!\u000e\u0005Ak!\u0002\u000e+!EQ\"\u0001M\u0001+\u0005A\u0012!g\u0007\t\u00135Q\u0011BA\u0005\u00021\tI!!C\u0001\u0019\u000f%\u0011\u0011\"\u0001M\u00011'\u00016\u0011\u0001+\u0004\u00065U\u0002\u0012C\u0007\u00021\u0003)\u0012\u0001G\u0001\u001a\u001c!IQBC\u0005\u0003\u0013\u0005A\"!\u0003\u0002\n\u0003a9\u0011BA\u0005\u00021\u0003A\u001a\u0002UB\u00013\u0013A!\"D\u0001\u0019\u000fA\u001b\u0011\u0001VB\u0003\u001bcA)\"D\u0001\u0019\u0002U\t\u0001$AM\u0006\t\u0005AI!D\u0001\u0019\u000bA\u001b\t!'\u0006\t\u001359\u0011BA\u0005\u00021\u0011I!!C\u0001\u0019\u0002aY\u0001kA\u0001U\u0007\u000biy\u0003#\u0006\u000e\u0003a\u0005Q#\u0001\r\u00023\u0013AI!D\u0001\u0019\tA\u001b\t!'\u0006\t\u001359\u0011BA\u0005\u00021\u0011I!!C\u0001\u0019\u0002aY\u0001kA\u0001U\u0007\u000bii\u0001c\u0006\u000e\u0003aaQ#\u0001\r\u0002)\u000e\u0015QR\u0002E\r\u001b\u0005AR\"F\u0001\u0019\u0003Q\u001b)!$\u0004\t\u001c5\t\u0001DD\u000b\u00021\u0005!6QAG\u0007\u0011;i\u0011\u0001\u0007\u0002\u0016\u0003a\tAk!\u0002\u000e!!yQ\u0002B\u0005\u0003\u0013\u0005AB\u0001g\b\u0016\u0003a\t\u00114\u0002\u0003\u0002\u0011\u0013i\u0011\u0001G\u0003Q\u0007\u0003!6QA\u0007\u0010\u0011=iA!\u0003\u0002\n\u0003a!\u0001tD\u000b\u00021\u0005IJ\u0001#\u0003\u000e\u0003a!\u0001k!\u0001U\u0007\u000biQ\u0002\u0003\t\u000e\u0003a!Q#\u0001\r\u00023\u0017!\u0011\u0001#\u0003\u000e\u0003a)\u0001k!\u0001U\u0007\u000biA\u0002\u0003\t\u000e\u0003a!Q#\u0001\r\u00023\u0013AI!D\u0001\u0019\tA\u001b\t\u0001VB\u0003\u001b\u001bA\t#D\u0001\u0019#U\t\u0001$\u0001+\u0004\u00065a\u00012E\u0007\u00021\u0003)\u0012\u0001G\u0001\u001a\n!\rQ\"\u0001\r\u0003!\u000e\u0005Ak!\u0002\u000e&!\u0011R\"\u0001M\u0001+\u0005A\u0012!'\u0003\t\b5\t\u0001\u0004\u0002)\u0004\u0002e-A!\u0001E\u0005\u001b\u0005AR\u0001U\u0002\u0002)\u000e\u0015Q2\u0005\u0005\u0013\u001b\u0005A\n!F\u0001\u0019\u0003e%\u0001rA\u0007\u00021\u0011\u00016\u0011AM\u0005\u0011\u0013i\u0011\u0001\u0007\u0003Q\u0007\u0005!6QAG\u0007\u0011Ki\u0011\u0001G\n\u0016\u0003a\tAk!\u0002"}, strings={"appendBytes", "", "Ljava/io/File;", "array", "", "FilesKt__FileReadWriteKt", "appendText", "text", "", "charset", "Ljava/nio/charset/Charset;", "bufferedReader", "Ljava/io/BufferedReader;", "bufferSize", "", "bufferedWriter", "Ljava/io/BufferedWriter;", "forEachBlock", "operation", "Lkotlin/Function2;", "blockSize", "forEachLine", "Lkotlin/Function1;", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "printWriter", "Ljava/io/PrintWriter;", "readBytes", "readLines", "", "readText", "reader", "Ljava/io/FileReader;", "writeBytes", "writeText", "writer", "Ljava/io/FileWriter;"}, multifileClassName="kotlin/io/FilesKt")
final class FilesKt__FileReadWriteKt {
    @NotNull
    public static final FileReader reader(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new FileReader($receiver);
    }

    @NotNull
    public static final BufferedReader bufferedReader(File $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TextStreamsKt.buffered(FilesKt.reader($receiver), bufferSize);
    }

    @NotNull
    public static /* synthetic */ BufferedReader bufferedReader$default(File file, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return FilesKt.bufferedReader(file, n);
    }

    @NotNull
    public static final FileWriter writer(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new FileWriter($receiver);
    }

    @NotNull
    public static final BufferedWriter bufferedWriter(File $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TextStreamsKt.buffered(FilesKt.writer($receiver), bufferSize);
    }

    @NotNull
    public static /* synthetic */ BufferedWriter bufferedWriter$default(File file, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return FilesKt.bufferedWriter(file, n);
    }

    @NotNull
    public static final PrintWriter printWriter(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new PrintWriter(FilesKt.bufferedWriter$default($receiver, 0, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] readBytes(File $receiver) {
        Object it2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Closeable $receiver2 = new FileInputStream($receiver);
        boolean closed = false;
        try {
            it2 = (FileInputStream)$receiver2;
            it2 = ByteStreamsKt.readBytes((InputStream)it2, (int)$receiver.length());
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver2.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver2.close();
            }
        }
        return (byte[])it2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeBytes(File $receiver, @NotNull byte[] array) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(array, "array");
        Closeable $receiver2 = new FileOutputStream($receiver);
        boolean closed = false;
        try {
            Object it2 = (FileOutputStream)$receiver2;
            ((FileOutputStream)it2).write(array);
            it2 = Unit.INSTANCE;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver2.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void appendBytes(File $receiver, @NotNull byte[] array) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(array, "array");
        Closeable $receiver2 = new FileOutputStream($receiver, true);
        boolean closed = false;
        try {
            Object it2 = (FileOutputStream)$receiver2;
            ((FileOutputStream)it2).write(array);
            it2 = Unit.INSTANCE;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver2.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver2.close();
            }
        }
    }

    @NotNull
    public static final String readText(File $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return ArraysKt.toString(FilesKt.readBytes($receiver), charset);
    }

    @NotNull
    public static final String readText(File $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return ArraysKt.toString(FilesKt.readBytes($receiver), charset);
    }

    @NotNull
    public static /* synthetic */ String readText$default(File file, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return FilesKt.readText(file, charset);
    }

    public static final void writeText(File $receiver, @NotNull String text, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(text, "text");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        FilesKt.writeBytes($receiver, StringsKt.toByteArray(text, charset));
    }

    public static final void writeText(File $receiver, @NotNull String text, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(text, "text");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        FilesKt.writeBytes($receiver, StringsKt.toByteArray(text, charset));
    }

    public static /* synthetic */ void writeText$default(File file, String string, Charset charset, int n) {
        if ((n & 2) != 0) {
            charset = Charsets.getUTF_8();
        }
        FilesKt.writeText(file, string, charset);
    }

    public static final void appendText(File $receiver, @NotNull String text, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(text, "text");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        FilesKt.appendBytes($receiver, StringsKt.toByteArray(text, charset));
    }

    public static /* synthetic */ void appendText$default(File file, String string, Charset charset, int n) {
        if ((n & 2) != 0) {
            charset = Charsets.getUTF_8();
        }
        FilesKt.appendText(file, string, charset);
    }

    public static final void appendText(File $receiver, @NotNull String text, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(text, "text");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        FilesKt.appendBytes($receiver, StringsKt.toByteArray(text, charset));
    }

    public static final void forEachBlock(File $receiver, @NotNull Function2<? super byte[], ? super Integer, ? extends Unit> operation) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        FilesKt.forEachBlock($receiver, operation, FilesKt.getDefaultBlockSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forEachBlock(File $receiver, @NotNull Function2<? super byte[], ? super Integer, ? extends Unit> operation, int blockSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        byte[] arr = new byte[blockSize < FilesKt.getMinimumBlockSize() ? FilesKt.getMinimumBlockSize() : blockSize];
        FileInputStream fis = new FileInputStream($receiver);
        try {
            do {
                int size;
                if ((size = fis.read(arr)) <= 0) {
                    break;
                }
                operation.invoke((byte[])arr, (Integer)size);
            } while (true);
        }
        finally {
            fis.close();
        }
    }

    public static final void forEachLine(File $receiver, @NotNull Charset charset, @NotNull Function1<? super String, ? extends Unit> operation) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        TextStreamsKt.forEachLine(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream($receiver), charset)), operation);
    }

    public static /* synthetic */ void forEachLine$default(File file, Charset charset, Function1 function1, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        FilesKt.forEachLine(file, charset, (Function1<? super String, ? extends Unit>)function1);
    }

    public static final void forEachLine(File $receiver, @NotNull String charset, @NotNull Function1<? super String, ? extends Unit> operation) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        Charset charset2 = Charset.forName(charset);
        Intrinsics.checkExpressionValueIsNotNull(charset2, "Charset.forName(charset)");
        FilesKt.forEachLine($receiver, charset2, operation);
    }

    @NotNull
    public static final List<String> readLines(File $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        Charset charset2 = Charset.forName(charset);
        Intrinsics.checkExpressionValueIsNotNull(charset2, "Charset.forName(charset)");
        return FilesKt.readLines($receiver, charset2);
    }

    @NotNull
    public static final InputStream inputStream(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new FileInputStream($receiver);
    }

    @NotNull
    public static final OutputStream outputStream(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new FileOutputStream($receiver);
    }

    @NotNull
    public static final List<String> readLines(File $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        ArrayList result = new ArrayList();
        FilesKt.forEachLine($receiver, charset, (Function1<? super String, ? extends Unit>)new Function1<String, Unit>(result){
            final /* synthetic */ ArrayList $result;

            public final void invoke(@NotNull String it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.$result.add(it2);
            }
            {
                this.$result = arrayList;
                super(1);
            }
        });
        return result;
    }

    @NotNull
    public static /* synthetic */ List readLines$default(File file, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return FilesKt.readLines(file, charset);
    }
}

