/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ClassDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PackageFragmentDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.BuiltInClassesAreSerializableOnJvm;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.platform.JvmBuiltIns;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.KtScope;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AdditionalSupertypes;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import kotlin.reflect.jvm.internal.impl.types.DelegatingType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;

public final class BuiltInClassesAreSerializableOnJvm
implements AdditionalSupertypes {
    private final KotlinType mockSerializableType;
    private final ModuleDescriptor moduleDescriptor;

    private final KotlinType createMockJavaIoSerializableType() {
        PackageFragmentDescriptorImpl mockJavaIoPackageFragment2 = new PackageFragmentDescriptorImpl(this.moduleDescriptor, new FqName("java.io")){

            @NotNull
            public KtScope.Empty getMemberScope() {
                return KtScope.Empty.INSTANCE;
            }
        };
        List<createMockJavaIoSerializableType.superTypes.1> superTypes2 = CollectionsKt.listOf(new DelegatingType(){

            @NotNull
            protected KotlinType getDelegate() {
                KotlinType kotlinType = JvmBuiltIns.Companion.getInstance().getAnyType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "JvmBuiltIns.Instance.anyType");
                return kotlinType;
            }
        });
        ClassDescriptorImpl mockSerializableClass = new ClassDescriptorImpl(mockJavaIoPackageFragment2, Name.identifier("Serializable"), Modality.ABSTRACT, (Collection<KotlinType>)superTypes2, SourceElement.NO_SOURCE);
        mockSerializableClass.initialize(KtScope.Empty.INSTANCE, SetsKt.<ConstructorDescriptor>emptySet(), null);
        KotlinType kotlinType = mockSerializableClass.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "mockSerializableClass.defaultType");
        return kotlinType;
    }

    @Override
    @NotNull
    public Collection<KotlinType> forClass(@NotNull DeserializedClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        if (this.isSerializableInJava(DescriptorUtilsKt.getFqNameSafe(classDescriptor))) {
            return CollectionsKt.listOf(this.mockSerializableType);
        }
        return CollectionsKt.listOf();
    }

    private final boolean isSerializableInJava(FqName classFqName) {
        Class<?> clazz;
        FqNameUnsafe fqNameUnsafe = classFqName.toUnsafe();
        if (Intrinsics.areEqual(fqNameUnsafe, KotlinBuiltIns.FQ_NAMES.array) || KotlinBuiltIns.isPrimitiveArray(fqNameUnsafe)) {
            return true;
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (classId == null) {
            return false;
        }
        ClassId javaClassId = classId;
        try {
            clazz = Class.forName(javaClassId.asSingleFqName().asString());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        Class<?> classViaReflection = clazz;
        return Serializable.class.isAssignableFrom(classViaReflection);
    }

    public BuiltInClassesAreSerializableOnJvm(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        this.moduleDescriptor = moduleDescriptor;
        this.mockSerializableType = this.createMockJavaIoSerializableType();
    }
}

