/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CapturedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PossiblyInnerType;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.PossiblyInnerTypeCapability;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.error.MissingDependencyErrorClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeParameterUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeParameterDescriptor> computeConstructorTypeParameters(ClassDescriptor $receiver) {
        void destination;
        void $receiver2;
        Annotated annotated;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        List<TypeParameterDescriptor> declaredParameters2 = $receiver.getDeclaredTypeParameters();
        if (!$receiver.isInner()) {
            List<TypeParameterDescriptor> list = declaredParameters2;
            Intrinsics.checkExpressionValueIsNotNull(list, "declaredParameters");
            return list;
        }
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        if ((annotated = (ClassDescriptor)declarationDescriptor) == null || (annotated = annotated.getTypeConstructor()) == null) {
            return CollectionsKt.emptyList();
        }
        Annotated containingTypeConstructor = annotated;
        Iterable $receiver3 = containingTypeConstructor.getParameters();
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
        for (Object item : $receiver2) {
            void it2;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item;
            void var9_9 = destination;
            CapturedTypeParameterDescriptor capturedTypeParameterDescriptor = TypeParameterUtilsKt.capturedCopyForInnerDeclaration((TypeParameterDescriptor)it2, $receiver, declaredParameters2.size());
            var9_9.add(capturedTypeParameterDescriptor);
        }
        List additional = (List)destination;
        if (additional.isEmpty()) {
            List<TypeParameterDescriptor> list = declaredParameters2;
            Intrinsics.checkExpressionValueIsNotNull(list, "declaredParameters");
            return list;
        }
        return CollectionsKt.plus((Collection)declaredParameters2, (Iterable)additional);
    }

    private static final CapturedTypeParameterDescriptor capturedCopyForInnerDeclaration(TypeParameterDescriptor $receiver, DeclarationDescriptor declarationDescriptor, int declaredTypeParametersCount) {
        return new CapturedTypeParameterDescriptor($receiver, declarationDescriptor, declaredTypeParametersCount);
    }

    @Nullable
    public static final PossiblyInnerType buildPossiblyInnerType(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.getConstructor().getDeclarationDescriptor() instanceof MissingDependencyErrorClass) {
            KotlinType $receiver2 = $receiver;
            PossiblyInnerTypeCapability possiblyInnerTypeCapability = $receiver2.getCapability(PossiblyInnerTypeCapability.class);
            return possiblyInnerTypeCapability != null ? possiblyInnerTypeCapability.getPossiblyInnerType() : null;
        }
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return TypeParameterUtilsKt.buildPossiblyInnerType($receiver, (ClassDescriptor)classifierDescriptor, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static final PossiblyInnerType buildPossiblyInnerType(KotlinType $receiver, ClassDescriptor classDescriptor, int index) {
        if (classDescriptor == null) {
            return null;
        }
        int toIndex = classDescriptor.getDeclaredTypeParameters().size() + index;
        List<TypeProjection> argumentsSubList = $receiver.getArguments().subList(index, toIndex);
        if (!classDescriptor.isInner()) {
            Unit unit;
            boolean bl = toIndex == $receiver.getArguments().size();
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value;
                if (value == false) {
                    String message = $receiver.getArguments().size() - toIndex + " trailing arguments were found in " + $receiver + " type";
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            return new PossiblyInnerType(classDescriptor, argumentsSubList, null);
        }
        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        return new PossiblyInnerType(classDescriptor, argumentsSubList, TypeParameterUtilsKt.buildPossiblyInnerType($receiver, (ClassDescriptor)declarationDescriptor, toIndex));
    }
}

