/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;

public final class OldPackageFacadeClassUtils {
    private static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";
    private static final String DEFAULT_PACKAGE_CLASS_NAME = "_DefaultPackage";

    private OldPackageFacadeClassUtils() {
    }

    @NotNull
    public static String getPackageClassName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "kotlin/reflect/jvm/internal/impl/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassName"));
        }
        if (packageFQN.isRoot()) {
            if (DEFAULT_PACKAGE_CLASS_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassName"));
            }
            return DEFAULT_PACKAGE_CLASS_NAME;
        }
        String string = OldPackageFacadeClassUtils.capitalizeNonEmptyString(packageFQN.shortName().asString()) + PACKAGE_CLASS_NAME_SUFFIX;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassName"));
        }
        return string;
    }

    @NotNull
    private static String capitalizeNonEmptyString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "kotlin/reflect/jvm/internal/impl/load/kotlin/OldPackageFacadeClassUtils", "capitalizeNonEmptyString"));
        }
        String string = Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/kotlin/OldPackageFacadeClassUtils", "capitalizeNonEmptyString"));
        }
        return string;
    }

    @NotNull
    public static FqName getPackageClassFqName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "kotlin/reflect/jvm/internal/impl/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassFqName"));
        }
        FqName fqName2 = packageFQN.child(Name.identifier(OldPackageFacadeClassUtils.getPackageClassName(packageFQN)));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassFqName"));
        }
        return fqName2;
    }

    @NotNull
    public static ClassId getPackageClassId(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "kotlin/reflect/jvm/internal/impl/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassId"));
        }
        ClassId classId = new ClassId(packageFQN, Name.identifier(OldPackageFacadeClassUtils.getPackageClassName(packageFQN)));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/load/kotlin/OldPackageFacadeClassUtils", "getPackageClassId"));
        }
        return classId;
    }
}

