/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.Collection;
import kotlin.ArraysKt;
import kotlin.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.util.collectionUtils.ScopeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.Printer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChainedScope
implements MemberScope {
    private final MemberScope[] scopeChain;
    private final String debugName;

    @Override
    @Nullable
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
        ClassifierDescriptor classifierDescriptor;
        block1: {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(location, "location");
            Object[] scopes = this.scopeChain;
            for (int i = 0; i < scopes.length; ++i) {
                Object scope2 = scopes[i];
                MemberScope it2 = (MemberScope)scope2;
                ClassifierDescriptor result = it2.getContributedClassifier(name, location);
                if (result == null) continue;
                classifierDescriptor = result;
                break block1;
            }
            classifierDescriptor = null;
        }
        return classifierDescriptor;
    }

    @Override
    @Nullable
    public PackageViewDescriptor getPackage(@NotNull Name name) {
        PackageViewDescriptor packageViewDescriptor;
        block1: {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Object[] scopes = this.scopeChain;
            for (int i = 0; i < scopes.length; ++i) {
                Object scope2 = scopes[i];
                MemberScope it2 = (MemberScope)scope2;
                PackageViewDescriptor result = it2.getPackage(name);
                if (result == null) continue;
                packageViewDescriptor = result;
                break block1;
            }
            packageViewDescriptor = null;
        }
        return packageViewDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<PropertyDescriptor> getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(location, "location");
        Object[] scopes = this.scopeChain;
        if (ArraysKt.isEmpty(scopes)) {
            collection = SetsKt.emptySet();
        } else {
            Collection result = null;
            for (int i = 0; i < scopes.length; ++i) {
                void it2;
                Object scope2 = scopes[i];
                MemberScope memberScope2 = (MemberScope)scope2;
                Collection collection2 = result;
                Collection<PropertyDescriptor> collection3 = it2.getContributedVariables(name, location);
                result = ScopeUtilsKt.concat(collection2, collection3);
            }
            collection = result;
            if (collection == null) {
                collection = SetsKt.emptySet();
            }
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<FunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(location, "location");
        Object[] scopes = this.scopeChain;
        if (ArraysKt.isEmpty(scopes)) {
            collection = SetsKt.emptySet();
        } else {
            Collection result = null;
            for (int i = 0; i < scopes.length; ++i) {
                void it2;
                Object scope2 = scopes[i];
                MemberScope memberScope2 = (MemberScope)scope2;
                Collection collection2 = result;
                Collection<FunctionDescriptor> collection3 = it2.getContributedFunctions(name, location);
                result = ScopeUtilsKt.concat(collection2, collection3);
            }
            collection = result;
            if (collection == null) {
                collection = SetsKt.emptySet();
            }
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, ? extends Boolean> nameFilter) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull(kindFilter, "kindFilter");
        Intrinsics.checkParameterIsNotNull(nameFilter, "nameFilter");
        Object[] scopes = this.scopeChain;
        if (ArraysKt.isEmpty(scopes)) {
            collection = SetsKt.emptySet();
        } else {
            Collection result = null;
            for (int i = 0; i < scopes.length; ++i) {
                void it2;
                Object scope2 = scopes[i];
                MemberScope memberScope2 = (MemberScope)scope2;
                Collection collection2 = result;
                Collection<DeclarationDescriptor> collection3 = it2.getContributedDescriptors(kindFilter, nameFilter);
                result = ScopeUtilsKt.concat(collection2, collection3);
            }
            collection = result;
            if (collection == null) {
                collection = SetsKt.emptySet();
            }
        }
        return collection;
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        Intrinsics.checkParameterIsNotNull(p, "p");
        p.println(this.getClass().getSimpleName(), ": ", this.debugName, " {");
        p.pushIndent();
        MemberScope[] memberScopeArray = this.scopeChain;
        for (int i = 0; i < memberScopeArray.length; ++i) {
            MemberScope scope2 = memberScopeArray[i];
            scope2.printScopeStructure(p);
        }
        p.popIndent();
        p.println("}");
    }

    public ChainedScope(@NotNull String debugName, MemberScope ... scopes) {
        Intrinsics.checkParameterIsNotNull(debugName, "debugName");
        Intrinsics.checkParameterIsNotNull(scopes, "scopes");
        this.debugName = debugName;
        this.scopeChain = (MemberScope[])((Object[])scopes).clone();
    }
}

